/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitbag;

import mod.chiselsandbits.bitbag.BagStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BagCapabilityProvider
extends BagStorage
implements ICapabilityProvider {
    private final LazyOptional<IItemHandler> capResult = LazyOptional.of(() -> this);

    public BagCapabilityProvider(ItemStack stack, CompoundNBT nbt) {
        this.stack = stack;
    }

    static int[] getStorageArray(ItemStack stack, int size) {
        int[] out = null;
        CompoundNBT compound = stack.func_77978_p();
        if (compound == null) {
            compound = new CompoundNBT();
        }
        if (compound.func_74764_b("contents")) {
            out = compound.func_74759_k("contents");
        }
        if (out == null) {
            stack.func_77982_d(compound);
            out = new int[size];
            compound.func_74783_a("contents", out);
        }
        if (out.length != size && compound != null) {
            int[] tmp = out;
            out = new int[size];
            System.arraycopy(out, 0, tmp, 0, Math.min(size, tmp.length));
            compound.func_74783_a("contents", out);
        }
        return out;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            this.setStorage(BagCapabilityProvider.getStorageArray(this.stack, 126));
            return this.capResult.cast();
        }
        return LazyOptional.empty();
    }
}

