/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.bitstorage;

import com.google.common.collect.Lists;
import java.util.List;
import mod.chiselsandbits.bitstorage.TileEntityBitStorage;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ExceptionNoTileEntity;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class BlockBitStorage
extends Block
implements ITileEntityProvider {
    private static final Property<Direction> FACING = HorizontalBlock.field_185512_D;

    public BlockBitStorage(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING});
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityBitStorage();
    }

    public TileEntityBitStorage getTileEntity(TileEntity te) throws ExceptionNoTileEntity {
        if (te instanceof TileEntityBitStorage) {
            return (TileEntityBitStorage)te;
        }
        throw new ExceptionNoTileEntity();
    }

    public TileEntityBitStorage getTileEntity(IBlockReader world, BlockPos pos) throws ExceptionNoTileEntity {
        return this.getTileEntity(world.func_175625_s(pos));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        try {
            TileEntityBitStorage tank = this.getTileEntity((IBlockReader)worldIn, pos);
            ItemStack current = ModUtil.nonNull(player.field_71071_by.func_70448_g());
            if (!ModUtil.isEmpty(current)) {
                TileEntityBitStorage wrappedTank = tank;
                if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)handIn, (IFluidHandler)wrappedTank)) {
                    return ActionResultType.SUCCESS;
                }
                if (tank.addHeldBits(current, player)) {
                    return ActionResultType.SUCCESS;
                }
            } else if (tank.addAllPossibleBits(player)) {
                return ActionResultType.SUCCESS;
            }
            if (tank.extractBits(player, hit.func_216347_e().field_72450_a, hit.func_216347_e().field_72448_b, hit.func_216347_e().field_72449_c, pos)) {
                return ActionResultType.SUCCESS;
            }
        }
        catch (ExceptionNoTileEntity e) {
            Log.noTileError(e);
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        if (builder.func_216019_b(LootParameters.field_216288_h) == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getTankDrop((TileEntityBitStorage)((Object)builder.func_216019_b(LootParameters.field_216288_h)))});
    }

    public ItemStack getTankDrop(TileEntityBitStorage bitTank) {
        ItemStack tankStack = new ItemStack((IItemProvider)this);
        tankStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY).ifPresent(s -> s.fill(bitTank.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).map(t -> t.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.EXECUTE)).orElse(FluidStack.EMPTY), IFluidHandler.FluidAction.EXECUTE));
        return tankStack;
    }
}

