/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.BoxType;
import mod.chiselsandbits.api.EventBlockBitPostModification;
import mod.chiselsandbits.api.EventFullBlockRestoration;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IChiseledBlockTileEntity;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.VoxelStats;
import mod.chiselsandbits.chiseledblock.BlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.chiseledblock.data.VoxelBlobStateReference;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.IChiseledTileContainer;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModTileEntityTypes;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.utils.SingleBlockBlockReader;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import org.jetbrains.annotations.NotNull;

public class TileEntityBlockChiseled
extends TileEntity
implements IChiseledTileContainer,
IChiseledBlockTileEntity {
    public static final ModelProperty<VoxelBlobStateReference> MP_VBSR = new ModelProperty();
    public static final ModelProperty<Integer> MP_PBSI = new ModelProperty();
    public IChiseledTileContainer occlusionState;
    boolean isNormalCube = false;
    int sideState = 0;
    int lightLevel = -1;
    private BlockState state;
    private VoxelBlobStateReference blobStateReference;
    private int primaryBlockStateId;
    private static final ThreadLocal<Integer> LOCAL_LIGHT_LEVEL = new ThreadLocal();
    private ItemStackGeneratedCache pickCache = null;

    public TileEntityBlockChiseled() {
        this((TileEntityType)ModTileEntityTypes.CHISELED.get());
    }

    public TileEntityBlockChiseled(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn == null ? (TileEntityType)ModTileEntityTypes.CHISELED.get() : tileEntityTypeIn);
    }

    public VoxelBlobStateReference getBlobStateReference() {
        return this.blobStateReference;
    }

    private void setBlobStateReference(VoxelBlobStateReference blobStateReference) {
        if (this.blobStateReference == null || !this.blobStateReference.equals(blobStateReference)) {
            this.blobStateReference = blobStateReference;
        }
    }

    public int getPrimaryBlockStateId() {
        return this.primaryBlockStateId;
    }

    public void setPrimaryBlockStateId(int primaryBlockStateId) {
        this.primaryBlockStateId = primaryBlockStateId;
        TileEntityBlockChiseled.setLightFromBlock(ModUtil.getStateById(primaryBlockStateId));
    }

    public IChiseledTileContainer getTileContainer() {
        if (this.occlusionState != null) {
            return this.occlusionState;
        }
        return this;
    }

    @Override
    public boolean isBlobOccluded(VoxelBlob blob) {
        return false;
    }

    @Override
    public void saveData() {
        super.func_70296_d();
    }

    @Override
    public void sendUpdate() {
        ModUtil.sendUpdate(Objects.requireNonNull(this.func_145831_w()), this.field_174879_c);
    }

    public void func_226984_a_(@NotNull World world, @NotNull BlockPos pos) {
        super.func_226984_a_(world, pos);
    }

    @Nonnull
    protected BlockState getState() {
        if (this.state == null) {
            this.state = ModBlocks.getChiseledDefaultState();
        }
        return Objects.requireNonNull(this.state);
    }

    public BlockState getBlockState(Block alternative) {
        int stateID = this.getPrimaryBlockStateId();
        BlockState state = ModUtil.getStateById(stateID);
        if (state != null) {
            return state;
        }
        return alternative.func_176223_P();
    }

    public void setState(BlockState blockState, VoxelBlobStateReference newRef) {
        VoxelBlobStateReference originalRef = this.getBlobStateReference();
        this.state = blockState;
        if (newRef != null && !newRef.equals(originalRef)) {
            EventBlockBitPostModification bmm = new EventBlockBitPostModification(Objects.requireNonNull(this.func_145831_w()), this.func_174877_v());
            MinecraftForge.EVENT_BUS.post((Event)bmm);
            this.setBlobStateReference(newRef);
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT compound = new CompoundNBT();
        this.writeChiselData(compound);
        if (compound.func_186856_d() == 0) {
            return null;
        }
        return new SUpdateTileEntityPacket(this.field_174879_c, 255, compound);
    }

    @NotNull
    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        this.writeChiselData(compound);
        return compound;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.readChiselData(tag);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        VoxelBlobStateReference current = this.getBlobStateReference();
        int oldLight = this.lightLevel;
        boolean changed = this.readChiselData(pkt.func_148857_g());
        if (this.field_145850_b != null && changed) {
            this.field_145850_b.func_225319_b(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), Blocks.field_150350_a.func_176223_P());
            if (oldLight != this.lightLevel) {
                this.field_145850_b.func_225524_e_().func_215568_a(this.field_174879_c);
            }
        }
        if (this.field_145850_b.func_201670_d()) {
            UndoTracker.getInstance().onNetworkUpdate(current, this.getBlobStateReference());
        }
    }

    public boolean readChiselData(CompoundNBT tag) {
        NBTBlobConverter converter = new NBTBlobConverter(false, this);
        return converter.readChisleData(tag, 3);
    }

    public void writeChiselData(CompoundNBT tag) {
        new NBTBlobConverter(false, this).writeChisleData(tag, false);
    }

    @NotNull
    public CompoundNBT func_189515_b(@NotNull CompoundNBT compound) {
        CompoundNBT nbt = super.func_189515_b(compound);
        this.writeChiselData(nbt);
        return nbt;
    }

    public void func_230337_a_(@NotNull BlockState state, @NotNull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.readChiselData(nbt);
    }

    @Override
    @NotNull
    public CompoundNBT writeTileEntityToTag(@NotNull CompoundNBT tag, boolean crossWorld) {
        CompoundNBT superNbt = super.func_189515_b(tag);
        new NBTBlobConverter(false, this).writeChisleData(superNbt, crossWorld);
        superNbt.func_74757_a("cw", crossWorld);
        return superNbt;
    }

    public void func_189668_a(@NotNull Mirror mirrorIn) {
        switch (mirrorIn) {
            case FRONT_BACK: {
                this.setBlob(this.getBlob().mirror(Direction.Axis.X), true);
                break;
            }
            case LEFT_RIGHT: {
                this.setBlob(this.getBlob().mirror(Direction.Axis.Z), true);
                break;
            }
        }
    }

    public void func_189667_a(@NotNull Rotation rotationIn) {
        VoxelBlob blob = ModUtil.rotate(this.getBlob(), Direction.Axis.Y, rotationIn);
        if (blob != null) {
            this.setBlob(blob, true);
        }
    }

    public void fillWith(BlockState blockType) {
        int ref = ModUtil.getStateId(blockType);
        this.sideState = 255;
        this.lightLevel = DeprecationHelper.getLightValue(blockType);
        this.isNormalCube = ModUtil.isNormalCube(blockType);
        BlockState defaultState = this.getState();
        if (ref != 0) {
            this.setPrimaryBlockStateId(ref);
        }
        this.setState(defaultState, new VoxelBlobStateReference(ModUtil.getStateId(blockType), TileEntityBlockChiseled.getPositionRandom(this.field_174879_c)));
        this.getTileContainer().saveData();
    }

    public static long getPositionRandom(BlockPos pos) {
        if (pos != null && EffectiveSide.get().isClient()) {
            return MathHelper.func_180186_a((Vector3i)pos);
        }
        return 0L;
    }

    public VoxelBlob getBlob() {
        VoxelBlobStateReference vbs = this.getBlobStateReference();
        VoxelBlob vb = vbs != null ? vbs.getVoxelBlob() : new VoxelBlob();
        return vb;
    }

    public void setBlob(VoxelBlob vb) {
        this.setBlob(vb, true);
    }

    public boolean updateBlob(NBTBlobConverter converter, boolean triggerUpdates) {
        VoxelBlobStateReference voxelRef;
        int oldLV = this.getLightValue();
        boolean oldNC = this.isNormalCube();
        int oldSides = this.sideState;
        VoxelBlobStateReference originalRef = this.getBlobStateReference();
        this.sideState = converter.getSideState();
        int b = converter.getPrimaryBlockStateID();
        this.lightLevel = converter.getLightValue();
        this.isNormalCube = converter.isNormalCube();
        try {
            voxelRef = converter.getVoxelRef(3, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c));
        }
        catch (Exception e) {
            Log.logError("Unable to read blob at " + this.func_174877_v(), e);
            voxelRef = new VoxelBlobStateReference(0, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c));
        }
        this.setPrimaryBlockStateId(b);
        this.setBlobStateReference(voxelRef);
        this.setState(this.getState(), voxelRef);
        if (this.func_145831_w() != null && triggerUpdates) {
            if (oldLV != this.getLightValue() || oldNC != this.isNormalCube()) {
                this.func_145831_w().func_225524_e_().func_215568_a(this.field_174879_c);
                BlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
                if (state.func_215686_e((IBlockReader)new SingleBlockBlockReader(state), BlockPos.field_177992_a) != this.isNormalCube && state.func_177230_c() instanceof BlockChiseled) {
                    this.func_145831_w().func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockChiseled.FULL_BLOCK, (Comparable)Boolean.valueOf(this.isNormalCube)));
                }
            }
            if (oldSides != this.sideState) {
                Objects.requireNonNull(this.field_145850_b).func_195593_d(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
            }
        }
        return voxelRef == null || !voxelRef.equals(originalRef);
    }

    public void setBlob(VoxelBlob vb, boolean triggerUpdates) {
        int olv = this.getLightValue();
        boolean oldNC = this.isNormalCube();
        VoxelStats common = vb.getVoxelStats();
        float light = common.blockLight;
        boolean nc = common.isNormalBlock;
        int lv = Math.max(0, Math.min(15, (int)(light * 15.0f)));
        int sideFlags = vb.getSideFlags(5, 11, 16);
        if (this.func_145831_w() == null) {
            if (common.mostCommonState == 0) {
                common.mostCommonState = this.getPrimaryBlockStateId();
            }
            this.sideState = sideFlags;
            this.lightLevel = lv;
            this.isNormalCube = nc;
            this.setBlobStateReference(new VoxelBlobStateReference(vb.blobToBytes(3), TileEntityBlockChiseled.getPositionRandom(this.field_174879_c)));
            this.setPrimaryBlockStateId(common.mostCommonState);
            this.setState(this.getState(), this.getBlobStateReference());
            return;
        }
        if (common.isFullBlock) {
            this.setBlobStateReference(new VoxelBlobStateReference(common.mostCommonState, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c)));
            this.setState(this.getState(), this.getBlobStateReference());
            BlockState newState = ModUtil.getStateById(common.mostCommonState);
            if (ChiselsAndBits.getConfig().getServer().canRevertToBlock(newState) && !MinecraftForge.EVENT_BUS.post((Event)new EventFullBlockRestoration(Objects.requireNonNull(this.field_145850_b), this.field_174879_c, newState))) {
                this.field_145850_b.func_180501_a(this.field_174879_c, newState, triggerUpdates ? 3 : 0);
            }
        } else if (common.mostCommonState != 0) {
            this.sideState = sideFlags;
            this.lightLevel = lv;
            this.isNormalCube = nc;
            this.setBlobStateReference(new VoxelBlobStateReference(vb.blobToBytes(3), TileEntityBlockChiseled.getPositionRandom(this.field_174879_c)));
            this.setPrimaryBlockStateId(common.mostCommonState);
            this.setState(this.getState(), this.getBlobStateReference());
            this.getTileContainer().saveData();
            this.getTileContainer().sendUpdate();
            Block blk = Objects.requireNonNull(this.field_145850_b).func_180495_p(this.field_174879_c).func_177230_c();
            if (triggerUpdates) {
                this.field_145850_b.func_195593_d(this.field_174879_c, blk);
            }
        } else {
            this.setBlobStateReference(new VoxelBlobStateReference(0, TileEntityBlockChiseled.getPositionRandom(this.field_174879_c)));
            this.setState(this.getState(), this.getBlobStateReference());
            ModUtil.removeChiseledBlock(Objects.requireNonNull(this.field_145850_b), this.field_174879_c);
        }
        if (olv != lv || oldNC != nc) {
            Objects.requireNonNull(this.field_145850_b).func_225524_e_().func_215568_a(this.field_174879_c);
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_215686_e((IBlockReader)new SingleBlockBlockReader(state), BlockPos.field_177992_a) != this.isNormalCube && state.func_177230_c() instanceof BlockChiseled) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockChiseled.FULL_BLOCK, (Comparable)Boolean.valueOf(this.isNormalCube)));
            }
        }
    }

    public ItemStack getItemStack(PlayerEntity player) {
        ItemStackGeneratedCache cache = this.pickCache;
        if (player != null) {
            Direction placingFace = ModUtil.getPlaceFace((LivingEntity)player);
            int rotations = ModUtil.getRotationIndex(placingFace);
            if (cache != null && cache.rotations == rotations && cache.ref == this.getBlobStateReference() && cache.out != null) {
                return cache.getItemStack();
            }
            VoxelBlob vb = this.getBlob();
            int countDown = rotations;
            while (countDown > 0) {
                --countDown;
                placingFace = placingFace.func_176735_f();
                vb = vb.spin(Direction.Axis.Y);
            }
            BitAccess ba = new BitAccess(null, null, vb, VoxelBlob.NULL_BLOB);
            ItemStack itemstack = ba.getBitsAsItem(placingFace, ItemType.CHISLED_BLOCK, false);
            this.pickCache = new ItemStackGeneratedCache(itemstack, this.getBlobStateReference(), rotations);
            return itemstack;
        }
        if (cache != null && cache.rotations == 0 && cache.ref == this.getBlobStateReference()) {
            return cache.getItemStack();
        }
        BitAccess ba = new BitAccess(null, null, this.getBlob(), VoxelBlob.NULL_BLOB);
        ItemStack itemstack = ba.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
        this.pickCache = new ItemStackGeneratedCache(itemstack, this.getBlobStateReference(), 0);
        return itemstack;
    }

    public boolean isNormalCube() {
        return this.isNormalCube;
    }

    public boolean isSideSolid(Direction side) {
        return (this.sideState & 1 << side.ordinal()) != 0;
    }

    public boolean isSideOpaque(Direction side) {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return this.isInnerSideOpaque(side);
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isInnerSideOpaque(Direction side) {
        int sideFlags = ChiseledBlockSmartModel.getSides(this);
        return (sideFlags & 1 << side.ordinal()) != 0;
    }

    public void completeEditOperation(VoxelBlob vb) {
        VoxelBlobStateReference before = this.getBlobStateReference();
        this.setBlob(vb);
        VoxelBlobStateReference after = this.getBlobStateReference();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_225319_b(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), Blocks.field_150350_a.func_176223_P());
        }
        UndoTracker.getInstance().add(this.func_145831_w(), this.func_174877_v(), before, after);
    }

    public void rotateBlock() {
        VoxelBlob occluded = new VoxelBlob();
        VoxelBlob postRotation = this.getBlob();
        int maxRotations = 4;
        while (--maxRotations > 0) {
            if (!occluded.canMerge(postRotation = postRotation.spin(Direction.Axis.Y))) continue;
            this.setBlob(postRotation);
            return;
        }
    }

    public boolean canMerge(VoxelBlob voxelBlob) {
        VoxelBlob vb = this.getBlob();
        IChiseledTileContainer occ = this.getTileContainer();
        return vb.canMerge(voxelBlob) && !occ.isBlobOccluded(voxelBlob);
    }

    @Override
    @NotNull
    public Collection<AxisAlignedBB> getBoxes(@NotNull BoxType type) {
        VoxelBlobStateReference ref = this.getBlobStateReference();
        if (ref != null) {
            return ref.getBoxes(type);
        }
        return Collections.emptyList();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        BlockPos p = this.func_174877_v();
        return new AxisAlignedBB((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p(), (double)(p.func_177958_n() + 1), (double)(p.func_177956_o() + 1), (double)(p.func_177952_p() + 1));
    }

    public void setNormalCube(boolean b) {
        this.isNormalCube = b;
    }

    public static void setLightFromBlock(BlockState defaultState) {
        if (defaultState == null) {
            LOCAL_LIGHT_LEVEL.remove();
        } else {
            LOCAL_LIGHT_LEVEL.set(DeprecationHelper.getLightValue(defaultState));
        }
    }

    public int getLightValue() {
        if (this.lightLevel < 0) {
            Integer tmp = LOCAL_LIGHT_LEVEL.get();
            this.lightLevel = tmp == null ? 0 : tmp;
        }
        return this.lightLevel;
    }

    @Override
    @NotNull
    public IBitAccess getBitAccess() {
        VoxelBlob mask = VoxelBlob.NULL_BLOB;
        if (this.field_145850_b != null) {
            mask = new VoxelBlob();
        }
        return new BitAccess(this.field_145850_b, this.field_174879_c, this.getBlob(), mask);
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(MP_PBSI, (Object)this.getPrimaryBlockStateId()).withInitial(MP_VBSR, (Object)this.getBlobStateReference()).build();
    }

    private static class ItemStackGeneratedCache {
        final ItemStack out;
        final VoxelBlobStateReference ref;
        final int rotations;

        public ItemStackGeneratedCache(ItemStack itemstack, VoxelBlobStateReference blobStateReference, int rotations2) {
            this.out = itemstack == null ? null : itemstack.func_77946_l();
            this.ref = blobStateReference;
            this.rotations = rotations2;
        }

        public ItemStack getItemStack() {
            return this.out == null ? null : this.out.func_77946_l();
        }
    }
}

