/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.data;

import javax.annotation.Nonnull;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.helpers.BitOperation;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;

public class BitLocation
implements IBitLocation {
    private static final double One32nd = 0.03125;
    @Nonnull
    public BlockPos blockPos;
    public int bitX;
    public int bitY;
    public int bitZ;

    @Override
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Override
    public int getBitX() {
        return this.bitX;
    }

    @Override
    public int getBitY() {
        return this.bitY;
    }

    @Override
    public int getBitZ() {
        return this.bitZ;
    }

    @Override
    public IBitLocation offSet(Direction direction) {
        int newBitX = this.bitX + direction.func_82601_c();
        int newBitY = this.bitY + direction.func_96559_d();
        int newBitZ = this.bitZ + direction.func_82599_e();
        return new BitLocation(this.blockPos, newBitX, newBitY, newBitZ);
    }

    public int snapToValid(int x) {
        return Math.min(Math.max(0, x), 15);
    }

    public BitLocation(BlockRayTraceResult mop, BitOperation type) {
        Vector3d hitVec = mop.func_216347_e();
        Vector3d accuratePos = new Vector3d((double)mop.func_216350_a().func_177958_n(), (double)mop.func_216350_a().func_177956_o(), (double)mop.func_216350_a().func_177952_p());
        Vector3d faceOffset = new Vector3d((double)mop.func_216354_b().func_176734_d().func_82601_c() * 0.03125, (double)mop.func_216354_b().func_176734_d().func_96559_d() * 0.03125, (double)mop.func_216354_b().func_176734_d().func_82599_e() * 0.03125);
        Vector3d hitDelta = hitVec.func_178788_d(accuratePos).func_178787_e(faceOffset);
        Vector3d inBlockPosAccurate = hitDelta.func_186678_a(16.0);
        Vector3i inBlockPos = new Vector3i((int)inBlockPosAccurate.func_82615_a(), (int)inBlockPosAccurate.func_82617_b(), (int)inBlockPosAccurate.func_82616_c());
        Vector3i normalizedInBlockPos = new Vector3i(this.snapToValid(inBlockPos.func_177958_n()), this.snapToValid(inBlockPos.func_177956_o()), this.snapToValid(inBlockPos.func_177952_p()));
        Vector3i normalizedInBlockPosWithOffset = type.usePlacementOffset() ? normalizedInBlockPos.func_177967_a(mop.func_216354_b(), 1) : normalizedInBlockPos;
        this.blockPos = mop.func_216350_a();
        this.bitX = normalizedInBlockPosWithOffset.func_177958_n();
        this.bitY = normalizedInBlockPosWithOffset.func_177956_o();
        this.bitZ = normalizedInBlockPosWithOffset.func_177952_p();
        this.normalize();
    }

    public BitLocation(BlockPos pos, int x, int y, int z) {
        this.blockPos = pos;
        this.bitX = x;
        this.bitY = y;
        this.bitZ = z;
        this.normalize();
    }

    public static BitLocation min(BitLocation from, BitLocation to) {
        int bitX = BitLocation.Min(from.blockPos.func_177958_n(), to.blockPos.func_177958_n(), from.bitX, to.bitX);
        int bitY = BitLocation.Min(from.blockPos.func_177956_o(), to.blockPos.func_177956_o(), from.bitY, to.bitY);
        int bitZ = BitLocation.Min(from.blockPos.func_177952_p(), to.blockPos.func_177952_p(), from.bitZ, to.bitZ);
        return new BitLocation(new BlockPos(Math.min(from.blockPos.func_177958_n(), to.blockPos.func_177958_n()), Math.min(from.blockPos.func_177956_o(), to.blockPos.func_177956_o()), Math.min(from.blockPos.func_177952_p(), to.blockPos.func_177952_p())), bitX, bitY, bitZ);
    }

    public static BitLocation max(BitLocation from, BitLocation to) {
        int bitX = BitLocation.Max(from.blockPos.func_177958_n(), to.blockPos.func_177958_n(), from.bitX, to.bitX);
        int bitY = BitLocation.Max(from.blockPos.func_177956_o(), to.blockPos.func_177956_o(), from.bitY, to.bitY);
        int bitZ = BitLocation.Max(from.blockPos.func_177952_p(), to.blockPos.func_177952_p(), from.bitZ, to.bitZ);
        return new BitLocation(new BlockPos(Math.max(from.blockPos.func_177958_n(), to.blockPos.func_177958_n()), Math.max(from.blockPos.func_177956_o(), to.blockPos.func_177956_o()), Math.max(from.blockPos.func_177952_p(), to.blockPos.func_177952_p())), bitX, bitY, bitZ);
    }

    private static int Min(int x, int x2, int bitX2, int bitX3) {
        if (x < x2) {
            return bitX2;
        }
        if (x2 == x) {
            return Math.min(bitX2, bitX3);
        }
        return bitX3;
    }

    private static int Max(int x, int x2, int bitX2, int bitX3) {
        if (x > x2) {
            return bitX2;
        }
        if (x2 == x) {
            return Math.max(bitX2, bitX3);
        }
        return bitX3;
    }

    private void normalize() {
        double xOffset = Math.floor((double)this.bitX / 16.0);
        double yOffset = Math.floor((double)this.bitY / 16.0);
        double zOffset = Math.floor((double)this.bitZ / 16.0);
        this.bitX = (this.bitX + 16) % 16;
        this.bitY = (this.bitY + 16) % 16;
        this.bitZ = (this.bitZ + 16) % 16;
        this.blockPos = this.blockPos.func_177963_a(xOffset, yOffset, zOffset);
    }
}

