/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.iterators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import mod.chiselsandbits.chiseledblock.iterators.BaseChiselIterator;
import mod.chiselsandbits.chiseledblock.iterators.ChiselIterator;
import mod.chiselsandbits.helpers.IVoxelSrc;
import mod.chiselsandbits.modes.ChiselMode;
import net.minecraft.util.Direction;

public class ChiselExtrudeIterator
extends BaseChiselIterator
implements ChiselIterator {
    final int INDEX_X = 0;
    final int INDEX_Y = 8;
    final int INDEX_Z = 16;
    Iterator<Integer> list;
    Direction side;
    int value;

    private int setValue(int pos, int idx) {
        return ((byte)pos & 0xFF) << idx;
    }

    private int getValue(int value, int idx) {
        return (byte)(value >>> idx & 0xFF);
    }

    private int createPos(int x, int y, int z) {
        return this.setValue(x, 0) | this.setValue(y, 8) | this.setValue(z, 16);
    }

    public ChiselExtrudeIterator(int dim, int sx, int sy, int sz, IVoxelSrc source, ChiselMode mode, Direction side, boolean place) {
        this.side = side;
        HashSet<Integer> possiblepositions = new HashSet<Integer>();
        ArrayList<Integer> selectedpositions = new ArrayList<Integer>();
        int tx = side.func_82601_c();
        int ty = side.func_96559_d();
        int tz = side.func_82599_e();
        int placeoffset = 0;
        int x = sx;
        int y = sy;
        int z = sz;
        if (place) {
            x -= tx;
            y -= ty;
            z -= tz;
            placeoffset = side.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1 : -1;
        }
        this.readyMatching(source, x, y, z);
        for (int b = 0; b < dim; ++b) {
            block6: for (int a = 0; a < dim; ++a) {
                switch (side) {
                    case DOWN: 
                    case UP: {
                        if (!this.isMatch(source, a, y, b) || source.getSafe(a + tx, y + ty, b + tz) != 0) continue block6;
                        possiblepositions.add(this.createPos(a, y + placeoffset, b));
                        continue block6;
                    }
                    case EAST: 
                    case WEST: {
                        if (!this.isMatch(source, x, a, b) || source.getSafe(x + tx, a + ty, b + tz) != 0) continue block6;
                        possiblepositions.add(this.createPos(x + placeoffset, a, b));
                        continue block6;
                    }
                    case NORTH: 
                    case SOUTH: {
                        if (!this.isMatch(source, a, b, z) || source.getSafe(a + tx, b + ty, z + tz) != 0) continue block6;
                        possiblepositions.add(this.createPos(a, b, z + placeoffset));
                        continue block6;
                    }
                    default: {
                        throw new NullPointerException();
                    }
                }
            }
        }
        this.floodFill(sx, sy, sz, possiblepositions, selectedpositions);
        Collections.sort(selectedpositions, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                int bY;
                int bX;
                int aX = ChiselExtrudeIterator.this.getValue(a, 0);
                if (aX != (bX = ChiselExtrudeIterator.this.getValue(b, 0))) {
                    return aX - bX;
                }
                int aY = ChiselExtrudeIterator.this.getValue(a, 8);
                if (aY != (bY = ChiselExtrudeIterator.this.getValue(b, 8))) {
                    return aY - bY;
                }
                int aZ = ChiselExtrudeIterator.this.getValue(a, 16);
                int bZ = ChiselExtrudeIterator.this.getValue(b, 16);
                return aZ - bZ;
            }
        });
        this.list = selectedpositions.iterator();
    }

    protected void readyMatching(IVoxelSrc source, int x, int y, int z) {
    }

    protected boolean isMatch(IVoxelSrc source, int x, int y, int z) {
        return source.getSafe(x, y, z) != 0;
    }

    private void floodFill(int sx, int sy, int sz, Set<Integer> possiblepositions, List<Integer> selectedpositions) {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(this.createPos(sx, sy, sz));
        while (!q.isEmpty()) {
            int pos = (Integer)q.poll();
            selectedpositions.add(pos);
            int x = this.getValue(pos, 0);
            int y = this.getValue(pos, 8);
            int z = this.getValue(pos, 16);
            possiblepositions.remove(pos);
            this.addIfExists(q, possiblepositions, this.createPos(x - 1, y, z));
            this.addIfExists(q, possiblepositions, this.createPos(x + 1, y, z));
            this.addIfExists(q, possiblepositions, this.createPos(x, y - 1, z));
            this.addIfExists(q, possiblepositions, this.createPos(x, y + 1, z));
            this.addIfExists(q, possiblepositions, this.createPos(x, y, z - 1));
            this.addIfExists(q, possiblepositions, this.createPos(x, y, z + 1));
        }
    }

    private void addIfExists(Queue<Integer> q, Set<Integer> possiblepositions, int pos) {
        if (possiblepositions.contains(pos)) {
            possiblepositions.remove(pos);
            q.add(pos);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.list.hasNext()) {
            this.value = this.list.next();
            return true;
        }
        return false;
    }

    @Override
    public Direction side() {
        return this.side;
    }

    @Override
    public int x() {
        return this.getValue(this.value, 0);
    }

    @Override
    public int y() {
        return this.getValue(this.value, 8);
    }

    @Override
    public int z() {
        return this.getValue(this.value, 16);
    }

    public static class ChiselExtrudeMaterialIterator
    extends ChiselExtrudeIterator {
        int material = 0;

        public ChiselExtrudeMaterialIterator(int dim, int sx, int sy, int sz, IVoxelSrc source, ChiselMode mode, Direction side, boolean place) {
            super(dim, sx, sy, sz, source, mode, side, place);
        }

        @Override
        protected void readyMatching(IVoxelSrc source, int x, int y, int z) {
            this.material = source.getSafe(x, y, z);
        }

        @Override
        protected boolean isMatch(IVoxelSrc source, int x, int y, int z) {
            return source.getSafe(x, y, z) == this.material;
        }
    }
}

