/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseledblock.serialization;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.core.Log;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class StringStates {
    public static int getStateIDFromName(String name) {
        String[] parts = name.split("[?&]");
        try {
            parts[0] = URLDecoder.decode(parts[0], "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.logError("Failed to reload Property from store data : " + name, e);
        }
        Block blk = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0]));
        if (blk == null || blk == Blocks.field_150350_a) {
            return 0;
        }
        BlockState state = blk.func_176223_P();
        if (state == null) {
            return 0;
        }
        for (int x = 1; x < parts.length; ++x) {
            try {
                String[] nameval;
                if (parts[x].length() <= 0 || (nameval = parts[x].split("[=]")).length != 2) continue;
                nameval[0] = URLDecoder.decode(nameval[0], "UTF-8");
                nameval[1] = URLDecoder.decode(nameval[1], "UTF-8");
                state = StringStates.withState(state, blk, nameval);
                continue;
            }
            catch (Exception err) {
                Log.logError("Failed to reload Property from store data : " + name, err);
            }
        }
        return ModUtil.getStateId(state);
    }

    private static BlockState withState(BlockState state, Block blk, String[] nameval) {
        Property prop = blk.func_176194_O().func_185920_a(nameval[0]);
        if (prop == null) {
            Log.info(nameval[0] + " is not a valid property for " + blk.getRegistryName());
            return state;
        }
        return StringStates.setPropValue(state, prop, nameval[1]);
    }

    public static <T extends Comparable<T>> BlockState setPropValue(BlockState blockState, Property<T> property, String value) {
        Optional pv = property.func_185929_b(value);
        if (pv.isPresent()) {
            return (BlockState)blockState.func_206870_a(property, (Comparable)pv.get());
        }
        Log.info(value + " is not a valid value of " + property.func_177701_a() + " for " + blockState.func_177230_c().getRegistryName());
        return blockState;
    }

    public static String getNameFromStateID(int key) {
        BlockState state = ModUtil.getStateById(key);
        Block blk = state.func_177230_c();
        String sname = "air?";
        try {
            StringBuilder stateName = new StringBuilder(URLEncoder.encode(Objects.requireNonNull(blk.getRegistryName()).toString(), "UTF-8"));
            stateName.append('?');
            boolean first = true;
            for (Property p : state.func_177230_c().func_176194_O().func_177623_d()) {
                if (!first) {
                    stateName.append('&');
                }
                first = false;
                Comparable propVal = state.func_177229_b(p);
                String saveAs = propVal instanceof IStringSerializable ? ((IStringSerializable)propVal).func_176610_l() : propVal.toString();
                stateName.append(URLEncoder.encode(p.func_177701_a(), "UTF-8"));
                stateName.append('=');
                stateName.append(URLEncoder.encode(saveAs, "UTF-8"));
            }
            sname = stateName.toString();
        }
        catch (UnsupportedEncodingException e) {
            Log.logError("Failed to Serialize State", e);
        }
        return sname;
    }
}

