/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import mod.chiselsandbits.chiseledblock.data.BitLocation;
import mod.chiselsandbits.client.RenderHelper;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.items.ItemTapeMeasure;
import mod.chiselsandbits.modes.IToolMode;
import mod.chiselsandbits.modes.TapeMeasureModes;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;

public class TapeMeasures {
    private static final double blockSize = 1.0;
    private static final double bitSize = 0.0625;
    private static final double halfBit = 0.03125;
    private final ArrayList<Measure> measures = new ArrayList();
    private Measure preview;

    public void clear() {
        this.measures.clear();
    }

    public void setPreviewMeasure(BitLocation a, BitLocation b, IToolMode chMode, ItemStack itemStack) {
        PlayerEntity player = ClientSide.instance.getPlayer();
        this.preview = a == null || b == null ? null : new Measure(a, b, chMode, this.getDimension(player), this.getColor(itemStack));
    }

    public void addMeasure(BitLocation a, BitLocation b, IToolMode chMode, ItemStack itemStack) {
        PlayerEntity player = ClientSide.instance.getPlayer();
        while (this.measures.size() > 0 && this.measures.size() >= (Integer)ChiselsAndBits.getConfig().getClient().maxTapeMeasures.get()) {
            this.measures.remove(0);
        }
        Measure newMeasure = new Measure(a, b, chMode, this.getDimension(player), this.getColor(itemStack));
        if (((Boolean)ChiselsAndBits.getConfig().getClient().displayMeasuringTapeInChat.get()).booleanValue()) {
            AxisAlignedBB box = newMeasure.getBoundingBox();
            double LenX = box.field_72336_d - box.field_72340_a;
            double LenY = box.field_72337_e - box.field_72338_b;
            double LenZ = box.field_72334_f - box.field_72339_c;
            double Len = newMeasure.getVecA().func_72438_d(newMeasure.getVecB());
            String out = chMode == TapeMeasureModes.DISTANCE ? this.getSize(Len) : DeprecationHelper.translateToLocal("mod.chiselsandbits.tapemeasure.chatmsg", this.getSize(LenX), this.getSize(LenY), this.getSize(LenZ));
            StringTextComponent chatMsg = new StringTextComponent(out);
            chatMsg.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)newMeasure.color.func_218388_g())));
            player.func_145747_a((ITextComponent)chatMsg, Util.field_240973_b_);
        }
        this.measures.add(newMeasure);
    }

    private DyeColor getColor(ItemStack itemStack) {
        return ((ItemTapeMeasure)ModItems.ITEM_TAPE_MEASURE.get()).getTapeColor(itemStack);
    }

    private ResourceLocation getDimension(PlayerEntity player) {
        return player.func_130014_f_().func_234923_W_().getRegistryName();
    }

    public void render(MatrixStack matrixStack, float partialTicks) {
        if (!this.measures.isEmpty() || this.preview != null) {
            PlayerEntity player = ClientSide.instance.getPlayer();
            if (this.hasTapeMeasure(player.field_71071_by)) {
                ArrayList<Measure> sortList = new ArrayList<Measure>(this.measures.size() + 1);
                if (this.preview != null) {
                    this.preview.calcDistance(partialTicks);
                    sortList.add(this.preview);
                }
                for (Measure m : this.measures) {
                    m.calcDistance(partialTicks);
                    sortList.add(m);
                }
                Collections.sort(sortList, new Comparator<Measure>(){

                    @Override
                    public int compare(Measure a, Measure b) {
                        return a.distance < b.distance ? 1 : (a.distance > b.distance ? -1 : 0);
                    }
                });
                for (Measure m : sortList) {
                    this.renderMeasure(m, m.distance, matrixStack, partialTicks);
                }
            }
        }
    }

    private boolean hasTapeMeasure(PlayerInventory inventory) {
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack is = inventory.func_70301_a(x);
            if (is.func_190926_b() || is.func_77973_b() != ModItems.ITEM_TAPE_MEASURE.get()) continue;
            return true;
        }
        return false;
    }

    private void renderMeasure(Measure m, double distance, MatrixStack matrixStack, float partialTicks) {
        PlayerEntity player = ClientSide.instance.getPlayer();
        if (m.DimensionId != this.getDimension(player)) {
            return;
        }
        int alpha = this.getAlphaFromRange(distance);
        if (alpha < 30) {
            return;
        }
        int val = m.color.func_218388_g();
        int red = val >> 16 & 0xFF;
        int green = val >> 8 & 0xFF;
        int blue = val & 0xFF;
        if (m.mode == TapeMeasureModes.DISTANCE) {
            Vector3d a = m.getVecA();
            Vector3d b = m.getVecB();
            RenderHelper.drawLineWithColor(matrixStack, a, b, BlockPos.field_177992_a, player, partialTicks, false, red, green, blue, alpha, (int)((double)alpha / 3.4));
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            double Len = a.func_72438_d(b) + 0.0625;
            this.renderSize(matrixStack, player, partialTicks, (a.field_72450_a + b.field_72450_a) * 0.5, (a.field_72448_b + b.field_72448_b) * 0.5, (a.field_72449_c + b.field_72449_c) * 0.5, Len, red, green, blue);
            RenderSystem.enableDepthTest();
            RenderSystem.enableCull();
            return;
        }
        AxisAlignedBB box = m.getBoundingBox();
        RenderHelper.drawSelectionBoundingBoxIfExistsWithColor(matrixStack, box.func_72321_a(-0.001, -0.001, -0.001), BlockPos.field_177992_a, player, partialTicks, false, red, green, blue, alpha, (int)((double)alpha / 3.4));
        RenderSystem.disableDepthTest();
        RenderSystem.disableCull();
        double LenX = box.field_72336_d - box.field_72340_a;
        double LenY = box.field_72337_e - box.field_72338_b;
        double LenZ = box.field_72334_f - box.field_72339_c;
        this.renderSize(matrixStack, player, partialTicks, box.field_72340_a, (box.field_72337_e + box.field_72338_b) * 0.5, box.field_72339_c, LenY, red, green, blue);
        this.renderSize(matrixStack, player, partialTicks, (box.field_72340_a + box.field_72336_d) * 0.5, box.field_72338_b, box.field_72339_c, LenX, red, green, blue);
        this.renderSize(matrixStack, player, partialTicks, box.field_72340_a, box.field_72338_b, (box.field_72339_c + box.field_72334_f) * 0.5, LenZ, red, green, blue);
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    private int getAlphaFromRange(double distance) {
        if (distance < 16.0) {
            return 102;
        }
        return (int)(102.0 - (distance - 16.0) * 6.0);
    }

    private static double AABBDistnace(Vector3d eyes, AxisAlignedBB box) {
        double boxPointX = Math.min(box.field_72336_d, Math.max(box.field_72340_a, eyes.field_72450_a));
        double boxPointY = Math.min(box.field_72337_e, Math.max(box.field_72338_b, eyes.field_72448_b));
        double boxPointZ = Math.min(box.field_72334_f, Math.max(box.field_72339_c, eyes.field_72449_c));
        return Math.sqrt(eyes.func_186679_c(boxPointX, boxPointY, boxPointZ));
    }

    private static double getLineDistance(Vector3d v, Vector3d w, PlayerEntity player, float partialTicks) {
        Vector3d p = player.func_174824_e(partialTicks);
        double segmentLength = v.func_72436_e(w);
        if (segmentLength == 0.0) {
            return p.func_72438_d(v);
        }
        double t = Math.max(0.0, Math.min(1.0, p.func_178788_d(v).func_72430_b(w.func_178788_d(v)) / segmentLength));
        Vector3d projection = v.func_178787_e(w.func_178788_d(v).func_186678_a(t));
        return p.func_72438_d(projection);
    }

    private void renderSize(MatrixStack matrixStack, PlayerEntity player, float partialTicks, double x, double y, double z, double len, int red, int green, int blue) {
        double letterSize = 5.0;
        double zScale = 0.001;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        String size = this.getSize(len);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(x, y + (double)this.getScale(len) * 5.0, z);
        this.billBoard(matrixStack, player, partialTicks);
        matrixStack.func_227862_a_(this.getScale(len), -this.getScale(len), 0.001f);
        matrixStack.func_227861_a_((double)(-fontRenderer.func_78256_a(size)) * 0.5, 0.0, 0.0);
        RenderSystem.disableDepthTest();
        IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        fontRenderer.func_228079_a_(size, 0.0f, 0.0f, red << 16 | green << 8 | blue, true, matrixStack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, true, 0, 0xF000F0);
        buffer.func_228461_a_();
        RenderSystem.enableDepthTest();
        matrixStack.func_227865_b_();
    }

    private float getScale(double maxLen) {
        double maxFontSize = 0.04;
        double minFontSize = 0.004;
        double delta = Math.min(1.0, maxLen / 4.0);
        double scale = 0.04 * delta + 0.004 * (1.0 - delta);
        if (maxLen < 0.25) {
            scale = 0.004;
        }
        return (float)Math.min(0.04, scale);
    }

    private void billBoard(MatrixStack matrixStack, PlayerEntity player, float partialTicks) {
        Entity view = Minecraft.func_71410_x().field_175622_Z;
        if (view != null) {
            float yaw = view.field_70126_B + (view.field_70177_z - view.field_70126_B) * partialTicks;
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f + -yaw, true));
            float pitch = view.field_70127_C + (view.field_70125_A - view.field_70127_C) * partialTicks;
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -pitch, true));
        }
    }

    private String getSize(double d) {
        double blocks = Math.floor(d);
        double bits = d - blocks;
        StringBuilder b = new StringBuilder();
        if (blocks > 0.0) {
            b.append((int)blocks).append("m");
        }
        if (bits * 16.0 > 0.9999) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append((int)(bits * 16.0)).append("b");
        }
        return b.toString();
    }

    private class Measure {
        public final IToolMode mode;
        public final BitLocation a;
        public final BitLocation b;
        public final DyeColor color;
        public final ResourceLocation DimensionId;
        public double distance = 1.0;

        public Measure(BitLocation a2, BitLocation b2, IToolMode chMode, ResourceLocation dimentionid, DyeColor color) {
            this.a = a2;
            this.b = b2;
            this.mode = chMode;
            this.DimensionId = dimentionid;
            this.color = color;
        }

        public AxisAlignedBB getBoundingBox() {
            if (this.mode == TapeMeasureModes.BLOCK) {
                double ax = this.a.blockPos.func_177958_n();
                double ay = this.a.blockPos.func_177956_o();
                double az = this.a.blockPos.func_177952_p();
                double bx = this.b.blockPos.func_177958_n();
                double by = this.b.blockPos.func_177956_o();
                double bz = this.b.blockPos.func_177952_p();
                return new AxisAlignedBB(Math.min(ax, bx), Math.min(ay, by), Math.min(az, bz), Math.max(ax, bx) + 1.0, Math.max(ay, by) + 1.0, Math.max(az, bz) + 1.0);
            }
            double ax = (double)this.a.blockPos.func_177958_n() + 0.0625 * (double)this.a.bitX;
            double ay = (double)this.a.blockPos.func_177956_o() + 0.0625 * (double)this.a.bitY;
            double az = (double)this.a.blockPos.func_177952_p() + 0.0625 * (double)this.a.bitZ;
            double bx = (double)this.b.blockPos.func_177958_n() + 0.0625 * (double)this.b.bitX;
            double by = (double)this.b.blockPos.func_177956_o() + 0.0625 * (double)this.b.bitY;
            double bz = (double)this.b.blockPos.func_177952_p() + 0.0625 * (double)this.b.bitZ;
            return new AxisAlignedBB(Math.min(ax, bx), Math.min(ay, by), Math.min(az, bz), Math.max(ax, bx) + 0.0625, Math.max(ay, by) + 0.0625, Math.max(az, bz) + 0.0625);
        }

        public Vector3d getVecA() {
            double ax = (double)this.a.blockPos.func_177958_n() + 0.0625 * (double)this.a.bitX + 0.03125;
            double ay = (double)this.a.blockPos.func_177956_o() + 0.0625 * (double)this.a.bitY + 0.03125;
            double az = (double)this.a.blockPos.func_177952_p() + 0.0625 * (double)this.a.bitZ + 0.03125;
            return new Vector3d(ax, ay, az);
        }

        public Vector3d getVecB() {
            double bx = (double)this.b.blockPos.func_177958_n() + 0.0625 * (double)this.b.bitX + 0.03125;
            double by = (double)this.b.blockPos.func_177956_o() + 0.0625 * (double)this.b.bitY + 0.03125;
            double bz = (double)this.b.blockPos.func_177952_p() + 0.0625 * (double)this.b.bitZ + 0.03125;
            return new Vector3d(bx, by, bz);
        }

        public void calcDistance(float partialTicks) {
            if (this.mode == TapeMeasureModes.DISTANCE) {
                Vector3d a = this.getVecA();
                Vector3d b = this.getVecB();
                PlayerEntity player = ClientSide.instance.getPlayer();
                this.distance = TapeMeasures.getLineDistance(a, b, player, partialTicks);
            } else {
                PlayerEntity player = ClientSide.instance.getPlayer();
                Vector3d eyes = player.func_174824_e(partialTicks);
                AxisAlignedBB box = this.getBoundingBox();
                this.distance = box.func_72318_a(eyes) ? 0.0 : TapeMeasures.AABBDistnace(eyes, box);
            }
        }
    }
}

