/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.core;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.client.UndoTracker;
import mod.chiselsandbits.config.Configuration;
import mod.chiselsandbits.core.ChiselsAndBitsClient;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.core.api.ChiselAndBitsAPI;
import mod.chiselsandbits.core.api.IMCHandler;
import mod.chiselsandbits.events.EventPlayerInteract;
import mod.chiselsandbits.events.VaporizeWater;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.network.NetworkChannel;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModContainerTypes;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.registry.ModRecipeSerializers;
import mod.chiselsandbits.registry.ModTileEntityTypes;
import mod.chiselsandbits.render.SmartModelManager;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockSmartModel;
import mod.chiselsandbits.utils.LanguageHandler;
import net.minecraft.block.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLModIdMappingEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="chiselsandbits")
public class ChiselsAndBits {
    @Nonnull
    public static final String MODID = "chiselsandbits";
    private static ChiselsAndBits instance;
    private Configuration config;
    private final IChiselAndBitsAPI api = new ChiselAndBitsAPI();
    private final NetworkChannel networkChannel = new NetworkChannel("chiselsandbits");
    List<ICacheClearable> cacheClearables = new ArrayList<ICacheClearable>();
    boolean idsHaveBeenMapped = false;

    public ChiselsAndBits() {
        instance = this;
        LanguageHandler.loadLangPath("assets/chiselsandbits/lang/%s.json");
        this.config = new Configuration(ModLoadingContext.get().getActiveContainer());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleIMCEvent);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::handleIMCEvent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ChiselsAndBitsClient::onClientInit));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ChiselsAndBitsClient::onModelRegistry));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> MinecraftForge.EVENT_BUS.register((Object)ClientSide.instance));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ChiselsAndBitsClient::registerIconTextures));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ChiselsAndBitsClient::retrieveRegisteredIconSprites));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(SmartModelManager.getInstance()::onModelBakeEvent));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(SmartModelManager.getInstance()::textureStichEvent));
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
        MinecraftForge.EVENT_BUS.addListener(this::handleIdMapping);
        MinecraftForge.EVENT_BUS.register((Object)new VaporizeWater());
        MinecraftForge.EVENT_BUS.register((Object)new EventPlayerInteract());
        ModBlocks.onModConstruction();
        ModContainerTypes.onModConstruction();
        ModItems.onModConstruction();
        ModRecipeSerializers.onModConstruction();
        ModTileEntityTypes.onModConstruction();
        this.networkChannel.registerCommonMessages();
    }

    public static ChiselsAndBits getInstance() {
        return instance;
    }

    public static Configuration getConfig() {
        return ChiselsAndBits.instance.config;
    }

    public static IChiselAndBitsAPI getApi() {
        return ChiselsAndBits.instance.api;
    }

    public static NetworkChannel getNetworkChannel() {
        return ChiselsAndBits.instance.networkChannel;
    }

    private void handleIMCEvent(InterModProcessEvent event) {
        IMCHandler imcHandler = new IMCHandler();
        imcHandler.handleIMCEvent();
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151583_m, Material.field_151571_B);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151574_g, Material.field_151573_f);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151572_C, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151570_A, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151589_v, Material.field_151576_e);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151569_G, Material.field_151585_k);
        ChiselsAndBits.getApi().addEquivilantMaterial(Material.field_151590_u, Material.field_151576_e);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).addListener(ChiseledBlockSmartModel::onConfigurationReload));
    }

    public void handleIdMapping(FMLModIdMappingEvent event) {
        this.idsHaveBeenMapped = true;
        BlockBitInfo.recalculate();
        this.clearCache();
    }

    public void clearCache() {
        if (this.idsHaveBeenMapped) {
            for (ICacheClearable clearable : this.cacheClearables) {
                clearable.clearCache();
            }
            this.addClearable(UndoTracker.getInstance());
            VoxelBlob.clearCache();
        }
    }

    public void addClearable(ICacheClearable cache) {
        if (!this.cacheClearables.contains(cache)) {
            this.cacheClearables.add(cache);
        }
    }
}

