/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.data.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.ldtteam.datagenerators.models.item.ItemModelJson;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import mod.chiselsandbits.registry.ModItems;
import mod.chiselsandbits.utils.Constants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockBitItemModelGenerator
implements IDataProvider {
    private final DataGenerator generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().func_200390_a((IDataProvider)new BlockBitItemModelGenerator(event.getGenerator()));
    }

    private BlockBitItemModelGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.actOnItemWithEmptyGenerated(cache, (Item)ModItems.ITEM_BLOCK_BIT.get());
    }

    public String func_200397_b() {
        return "Chisel block item model generator";
    }

    public void actOnItemWithEmptyGenerated(DirectoryCache cache, Item item) throws IOException {
        ItemModelJson json = new ItemModelJson();
        json.setParent("item/generated");
        this.saveItemJson(cache, json, Objects.requireNonNull(item.getRegistryName()).func_110623_a());
    }

    private void saveItemJson(DirectoryCache cache, ItemModelJson json, String name) throws IOException {
        Path itemModelFolder = this.generator.func_200391_b().resolve("assets/chiselsandbits/models/item/");
        Path itemModelPath = itemModelFolder.resolve(name + ".json");
        IDataProvider.func_218426_a((Gson)Constants.DataGenerator.GSON, (DirectoryCache)cache, (JsonElement)json.serialize(), (Path)itemModelPath);
    }
}

