/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import javax.annotation.Nonnull;
import mod.chiselsandbits.api.EventBlockBitModification;
import mod.chiselsandbits.helpers.PlayerCopiedInventory;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;

public class ActingPlayer {
    private final IInventory storage;
    private final PlayerEntity innerPlayer;
    private final boolean realPlayer;
    private final Hand hand;
    BlockPos lastPos = null;
    Boolean lastPlacement = null;
    ItemStack lastPermissionBit = null;
    Boolean permissionResult = null;

    private ActingPlayer(PlayerEntity player, boolean realPlayer, Hand hand) {
        this.innerPlayer = player;
        this.hand = hand;
        this.realPlayer = realPlayer;
        this.storage = realPlayer ? player.field_71071_by : new PlayerCopiedInventory(player.field_71071_by);
    }

    public IInventory getInventory() {
        return this.storage;
    }

    public int getCurrentItem() {
        return this.innerPlayer.field_71071_by.field_70461_c;
    }

    public boolean isCreative() {
        return this.innerPlayer.func_184812_l_();
    }

    public ItemStack getCurrentEquippedItem() {
        return this.storage.func_70301_a(this.getCurrentItem());
    }

    public boolean canPlayerManipulate(@Nonnull BlockPos pos, @Nonnull Direction side, @Nonnull ItemStack is, boolean placement) {
        if (this.permissionResult == null || this.lastPermissionBit != is || this.lastPos != pos || placement != this.lastPlacement) {
            EventBlockBitModification event;
            this.lastPos = pos;
            this.lastPlacement = placement;
            this.lastPermissionBit = is;
            this.permissionResult = this.innerPlayer.func_175151_a(pos, side, is) && this.innerPlayer.func_130014_f_().func_175660_a(this.innerPlayer, pos) ? Boolean.valueOf(!MinecraftForge.EVENT_BUS.post((Event)(event = new EventBlockBitModification(this.innerPlayer.func_130014_f_(), pos, this.innerPlayer, this.hand, is, placement)))) : Boolean.valueOf(false);
        }
        return this.permissionResult;
    }

    public void damageItem(ItemStack stack, int amount) {
        if (this.realPlayer) {
            stack.func_222118_a(amount, (LivingEntity)this.innerPlayer, playerEntity -> {});
        } else {
            stack.func_196085_b(stack.func_77952_i() + amount);
        }
    }

    public void playerDestroyItem(@Nonnull ItemStack stack, Hand hand) {
        if (this.realPlayer) {
            ForgeEventFactory.onPlayerDestroyItem((PlayerEntity)this.innerPlayer, (ItemStack)stack, (Hand)hand);
        }
    }

    @Nonnull
    public static ActingPlayer actingAs(PlayerEntity player, Hand hand) {
        return new ActingPlayer(player, true, hand);
    }

    @Nonnull
    public static ActingPlayer testingAs(PlayerEntity player, Hand hand) {
        return new ActingPlayer(player, false, hand);
    }

    public World getWorld() {
        return this.innerPlayer.func_130014_f_();
    }

    public PlayerEntity getPlayer() {
        return this.innerPlayer;
    }

    public boolean isReal() {
        return this.realPlayer;
    }

    public Hand getHand() {
        return this.hand;
    }
}

