/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.chiselsandbits.bitbag.BagInventory;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.NBTBlobConverter;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ActingPlayer;
import mod.chiselsandbits.helpers.IItemInInventory;
import mod.chiselsandbits.helpers.ItemStackSlot;
import mod.chiselsandbits.helpers.StateLookup;
import mod.chiselsandbits.items.ItemBitBag;
import mod.chiselsandbits.items.ItemChiseledBit;
import mod.chiselsandbits.items.ItemNegativePrint;
import mod.chiselsandbits.items.ItemPositivePrint;
import mod.chiselsandbits.render.helpers.SimpleInstanceCache;
import mod.chiselsandbits.utils.SingleBlockBlockReader;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.GrassPathBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.GameData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ModUtil {
    @Nonnull
    public static final String NBT_SIDE = "side";
    @Nonnull
    public static final String NBT_BLOCKENTITYTAG = "BlockEntityTag";
    private static final Random RAND = new Random();
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final SimpleInstanceCache<CompoundNBT, VoxelBlob> STACK_VOXEL_BLOB_SIMPLE_INSTANCE_CACHE = new SimpleInstanceCache<CompoundNBT, Object>(new CompoundNBT(), null);
    private static StateLookup IDRelay = new StateLookup();

    public static Direction getPlaceFace(LivingEntity placer) {
        return Direction.func_196054_a((Entity)placer)[0].func_176734_d();
    }

    public static Pair<Vector3d, Vector3d> getPlayerRay(PlayerEntity playerIn) {
        double reachDistance = 5.0;
        double x = playerIn.field_70169_q + (playerIn.func_226277_ct_() - playerIn.field_70169_q);
        double y = playerIn.field_70167_r + (playerIn.func_226278_cu_() - playerIn.field_70167_r) + (double)playerIn.func_70047_e();
        double z = playerIn.field_70166_s + (playerIn.func_226281_cx_() - playerIn.field_70166_s);
        float playerPitch = playerIn.field_70127_C + (playerIn.field_70125_A - playerIn.field_70127_C);
        float playerYaw = playerIn.field_70126_B + (playerIn.field_70177_z - playerIn.field_70126_B);
        float yawRayX = MathHelper.func_76126_a((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawRayZ = MathHelper.func_76134_b((float)(-playerYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float pitchMultiplier = -MathHelper.func_76134_b((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayY = MathHelper.func_76126_a((float)(-playerPitch * ((float)Math.PI / 180)));
        float eyeRayX = yawRayX * pitchMultiplier;
        float eyeRayZ = yawRayZ * pitchMultiplier;
        if (playerIn instanceof ServerPlayerEntity) {
            reachDistance = playerIn.func_233637_b_((Attribute)ForgeMod.REACH_DISTANCE.get());
        }
        Vector3d from = new Vector3d(x, y, z);
        Vector3d to = from.func_72441_c((double)eyeRayX * reachDistance, (double)eyeRayY * reachDistance, (double)eyeRayZ * reachDistance);
        return Pair.of((Object)from, (Object)to);
    }

    public static IItemInInventory findBit(ActingPlayer who, BlockPos pos, int StateID) {
        ItemStack inHand = who.getCurrentEquippedItem();
        IInventory inv = who.getInventory();
        boolean canEdit = who.canPlayerManipulate(pos, Direction.UP, inHand, true);
        if (ModUtil.getStackSize(inHand) > 0 && inHand.func_77973_b() instanceof ItemChiseledBit && ItemChiseledBit.getStackState(inHand) == StateID) {
            return new ItemStackSlot(inv, who.getCurrentItem(), inHand, who, canEdit);
        }
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack is = inv.func_70301_a(x);
            if (ModUtil.getStackSize(is) <= 0 || !(is.func_77973_b() instanceof ItemChiseledBit) || !ItemChiseledBit.sameBit(is, StateID)) continue;
            return new ItemStackSlot(inv, x, is, who, canEdit);
        }
        return new ItemStackSlot(inv, -1, ModUtil.getEmptyStack(), who, canEdit);
    }

    @Nonnull
    public static ItemStack copy(ItemStack st) {
        if (st == null) {
            return ModUtil.getEmptyStack();
        }
        return ModUtil.nonNull(st.func_77946_l());
    }

    @Nonnull
    public static ItemStack nonNull(ItemStack st) {
        if (st == null) {
            return ModUtil.getEmptyStack();
        }
        return st;
    }

    public static boolean isHoldingPattern(PlayerEntity player) {
        ItemStack inHand = player.func_184614_ca();
        if (inHand != null && inHand.func_77973_b() instanceof ItemPositivePrint) {
            return true;
        }
        return inHand != null && inHand.func_77973_b() instanceof ItemNegativePrint;
    }

    public static boolean isHoldingChiseledBlock(PlayerEntity player) {
        ItemStack inHand = player.func_184614_ca();
        return inHand != null && inHand.func_77973_b() instanceof ItemBlockChiseled;
    }

    public static int getRotationIndex(Direction face) {
        return face.func_176736_b();
    }

    public static int getRotations(LivingEntity placer, Direction oldYaw) {
        int rotations;
        Direction newFace = ModUtil.getPlaceFace(placer);
        for (rotations = ModUtil.getRotationIndex(newFace) - ModUtil.getRotationIndex(oldYaw); rotations < 0; rotations = 4 + rotations) {
        }
        while (rotations > 4) {
            rotations -= 4;
        }
        return 4 - rotations;
    }

    public static BlockPos getPartialOffset(Direction side, BlockPos partial, IntegerBox modelBounds) {
        int offset_x = modelBounds.minX;
        int offset_y = modelBounds.minY;
        int offset_z = modelBounds.minZ;
        int partial_x = partial.func_177958_n();
        int partial_y = partial.func_177956_o();
        int partial_z = partial.func_177952_p();
        int middle_x = (modelBounds.maxX - modelBounds.minX) / -2;
        int middle_y = (modelBounds.maxY - modelBounds.minY) / -2;
        int middle_z = (modelBounds.maxZ - modelBounds.minZ) / -2;
        switch (side) {
            case DOWN: {
                offset_y = modelBounds.maxY;
                middle_y = 0;
                break;
            }
            case EAST: {
                offset_x = modelBounds.minX;
                middle_x = 0;
                break;
            }
            case NORTH: {
                offset_z = modelBounds.maxZ;
                middle_z = 0;
                break;
            }
            case SOUTH: {
                offset_z = modelBounds.minZ;
                middle_z = 0;
                break;
            }
            case UP: {
                offset_y = modelBounds.minY;
                middle_y = 0;
                break;
            }
            case WEST: {
                offset_x = modelBounds.maxX;
                middle_x = 0;
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        int t_x = -offset_x + middle_x + partial_x;
        int t_y = -offset_y + middle_y + partial_y;
        int t_z = -offset_z + middle_z + partial_z;
        return new BlockPos(t_x, t_y, t_z);
    }

    @SafeVarargs
    public static <T> T firstNonNull(T ... options) {
        for (T i : options) {
            if (i == null) continue;
            return i;
        }
        throw new NullPointerException("Unable to find a non null item.");
    }

    public static TileEntity getTileEntitySafely(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        if (world instanceof World) {
            return ((World)world).func_175726_f(pos).func_177424_a(pos, Chunk.CreateEntityType.CHECK);
        }
        return world.func_175625_s(pos);
    }

    public static TileEntityBlockChiseled getChiseledTileEntity(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        TileEntity te = ModUtil.getTileEntitySafely(world, pos);
        if (te instanceof TileEntityBlockChiseled) {
            return (TileEntityBlockChiseled)te;
        }
        return null;
    }

    public static TileEntityBlockChiseled getChiseledTileEntity(@Nonnull World world, @Nonnull BlockPos pos, boolean create) {
        if (world.func_175667_e(pos)) {
            TileEntity te = world.func_175726_f(pos).func_177424_a(pos, Chunk.CreateEntityType.CHECK);
            if (te instanceof TileEntityBlockChiseled) {
                return (TileEntityBlockChiseled)te;
            }
            return null;
        }
        return null;
    }

    public static void removeChiseledBlock(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        BlockState oldState = world.func_180495_p(pos);
        if (te instanceof TileEntityBlockChiseled) {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            return;
        }
        world.func_225319_b(pos, oldState, Blocks.field_150350_a.func_176223_P());
    }

    public static boolean containsAtLeastOneOf(IInventory inv, ItemStack is) {
        boolean seen = false;
        for (int x = 0; x < inv.func_70302_i_(); ++x) {
            ItemStack which = inv.func_70301_a(x);
            if (which == null || which.func_77973_b() != is.func_77973_b() || !ItemChiseledBit.sameBit(which, ItemChiseledBit.getStackState(is)) || seen) continue;
            seen = true;
        }
        return seen;
    }

    public static List<BagInventory> getBags(ActingPlayer player) {
        if (player.isCreative()) {
            return Collections.emptyList();
        }
        ArrayList<BagInventory> bags = new ArrayList<BagInventory>();
        IInventory inv = player.getInventory();
        for (int zz = 0; zz < inv.func_70302_i_(); ++zz) {
            ItemStack which = inv.func_70301_a(zz);
            if (which == null || !(which.func_77973_b() instanceof ItemBitBag)) continue;
            bags.add(new BagInventory(which));
        }
        return bags;
    }

    public static int consumeBagBit(List<BagInventory> bags, int inPattern, int howMany) {
        int remaining = howMany;
        for (BagInventory inv : bags) {
            if ((remaining -= inv.extractBit(inPattern, remaining)) != 0) continue;
            return howMany;
        }
        return howMany - remaining;
    }

    public static VoxelBlob getBlobFromStack(ItemStack stack, LivingEntity rotationPlayer) {
        if (stack.func_77942_o()) {
            VoxelBlob blob;
            CompoundNBT cData = ModUtil.getSubCompound(stack, NBT_BLOCKENTITYTAG, false);
            if (STACK_VOXEL_BLOB_SIMPLE_INSTANCE_CACHE.needsUpdate(cData)) {
                NBTBlobConverter tmp = new NBTBlobConverter();
                if (cData.func_186856_d() == 0) {
                    cData = stack.func_77978_p();
                }
                tmp.readChisleData(cData, -1);
                blob = tmp.getBlob();
                STACK_VOXEL_BLOB_SIMPLE_INSTANCE_CACHE.updateCachedValue(new VoxelBlob(blob));
            } else {
                blob = new VoxelBlob(STACK_VOXEL_BLOB_SIMPLE_INSTANCE_CACHE.getCached());
            }
            if (rotationPlayer != null) {
                int xrotations = ModUtil.getRotations(rotationPlayer, ModUtil.getSide(stack));
                while (xrotations-- > 0) {
                    blob = blob.spin(Direction.Axis.Y);
                }
            }
            return blob;
        }
        return new VoxelBlob();
    }

    public static void sendUpdate(@Nullable World worldObj, @Nonnull BlockPos pos) {
        if (worldObj == null) {
            return;
        }
        BlockState state = worldObj.func_180495_p(pos);
        worldObj.func_184138_a(pos, state, state, 0);
    }

    private static Item getItem(@NotNull BlockState blockState) {
        Block block = blockState.func_177230_c();
        if (block.equals(Blocks.field_150353_l)) {
            return Items.field_151129_at;
        }
        if (block instanceof CropsBlock) {
            ItemStack stack = ((CropsBlock)block).func_185473_a(null, null, blockState);
            if (stack != null) {
                return stack.func_77973_b();
            }
            return Items.field_151014_N;
        }
        if (block instanceof FarmlandBlock || block instanceof GrassPathBlock) {
            return ModUtil.getItemFromBlock(Blocks.field_150346_d);
        }
        if (block instanceof FireBlock) {
            return Items.field_151033_d;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.field_222087_nH;
        }
        if (block == Blocks.field_222404_kP) {
            return Items.field_222068_kQ;
        }
        return ModUtil.getItemFromBlock(block);
    }

    private static Item getItemFromBlock(Block block) {
        return (Item)GameData.getBlockItemMap().get(block);
    }

    public static ItemStack getItemStackFromBlockState(@NotNull BlockState blockState) {
        if (blockState.func_177230_c() instanceof IFluidBlock) {
            return FluidUtil.getFilledBucket((FluidStack)new FluidStack(((IFluidBlock)blockState.func_177230_c()).getFluid(), 1000));
        }
        Item item = ModUtil.getItem(blockState);
        if (item != Items.field_190931_a && item != null) {
            return new ItemStack((IItemProvider)item, 1);
        }
        return new ItemStack((IItemProvider)blockState.func_177230_c(), 1);
    }

    @Nullable
    public static VoxelBlob rotate(VoxelBlob blob, Direction.Axis axis, Rotation rotation) {
        switch (rotation) {
            case CLOCKWISE_90: {
                return blob.spin(axis).spin(axis).spin(axis);
            }
            case CLOCKWISE_180: {
                return blob.spin(axis).spin(axis);
            }
            case COUNTERCLOCKWISE_90: {
                return blob.spin(axis);
            }
        }
        return null;
    }

    public static boolean isNormalCube(BlockState blockType, IBlockReader reader, BlockPos pos) {
        return blockType.func_215686_e(reader, pos);
    }

    public static boolean isNormalCube(BlockState blockState) {
        return ModUtil.isNormalCube(blockState, new SingleBlockBlockReader(blockState, blockState.func_177230_c()), BlockPos.field_177992_a);
    }

    public static Direction getSide(ItemStack stack) {
        if (stack != null) {
            CompoundNBT c;
            CompoundNBT blueprintTag = stack.func_77978_p();
            int byteValue = Direction.NORTH.ordinal();
            if (blueprintTag == null) {
                return Direction.NORTH;
            }
            if (blueprintTag.func_74764_b(NBT_SIDE)) {
                byteValue = blueprintTag.func_74771_c(NBT_SIDE);
            }
            if (blueprintTag.func_74764_b(NBT_BLOCKENTITYTAG) && (c = blueprintTag.func_74775_l(NBT_BLOCKENTITYTAG)).func_74764_b(NBT_SIDE)) {
                byteValue = c.func_74771_c(NBT_SIDE);
            }
            Direction side = Direction.NORTH;
            if (byteValue >= 0 && byteValue < Direction.values().length) {
                side = Direction.values()[byteValue];
            }
            if (side == Direction.DOWN || side == Direction.UP) {
                side = Direction.NORTH;
            }
            return side;
        }
        return Direction.NORTH;
    }

    public static void setSide(ItemStack stack, Direction side) {
        if (stack != null) {
            CompoundNBT blueprintTag = stack.func_77978_p();
            if (blueprintTag == null) {
                blueprintTag = new CompoundNBT();
            }
            if (blueprintTag.func_74764_b(NBT_BLOCKENTITYTAG)) {
                blueprintTag.func_74775_l(NBT_BLOCKENTITYTAG).func_74774_a(NBT_SIDE, (byte)side.ordinal());
            }
            blueprintTag.func_74768_a(NBT_SIDE, side.ordinal());
            stack.func_77982_d(blueprintTag);
        }
    }

    public static BlockState getStateById(int blockStateID) {
        return IDRelay.getStateById(blockStateID);
    }

    public static int getStateId(BlockState state) {
        return Math.max(0, IDRelay.getStateId(state));
    }

    public static void cacheFastStates() {
        if (!((Boolean)ChiselsAndBits.getConfig().getServer().lowMemoryMode.get()).booleanValue()) {
            IDRelay = new StateLookup.CachedStateLookup();
        }
    }

    public static int getStackSize(ItemStack stack) {
        return stack == null ? 0 : stack.func_190916_E();
    }

    public static void setStackSize(@Nonnull ItemStack stack, int stackSize) {
        stack.func_190920_e(stackSize);
    }

    public static void adjustStackSize(@Nonnull ItemStack is, int sizeDelta) {
        ModUtil.setStackSize(is, ModUtil.getStackSize(is) + sizeDelta);
    }

    public static CompoundNBT getSubCompound(ItemStack stack, String tag, boolean create) {
        if (create && !stack.func_196082_o().func_74764_b(tag)) {
            Objects.requireNonNull(stack.func_77978_p()).func_218657_a(tag, (INBT)new CompoundNBT());
        }
        return stack.func_196082_o().func_74775_l(tag);
    }

    @Nonnull
    public static ItemStack getEmptyStack() {
        return ItemStack.field_190927_a;
    }

    public static boolean notEmpty(ItemStack itemStack) {
        return itemStack != null && !itemStack.func_190926_b();
    }

    public static boolean isEmpty(ItemStack itemStack) {
        return itemStack == null || itemStack.func_190926_b();
    }

    @Nonnull
    public static CompoundNBT getTagCompound(ItemStack ei) {
        return ei.func_196082_o();
    }

    public static BlockState getStateFromItem(ItemStack is) {
        try {
            if (!ModUtil.isEmpty(is) && is.func_77973_b() instanceof BlockItem) {
                BlockItem iblk = (BlockItem)is.func_77973_b();
                BlockState state = iblk.func_179223_d().func_176223_P();
                return state;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public static void damageItem(@Nonnull ItemStack is, @Nonnull Random r) {
        if (is.func_77984_f() && is.func_96631_a(1, r, null)) {
            is.func_190918_g(1);
            is.func_196085_b(0);
        }
    }

    @Nonnull
    public static ItemStack makeStack(Item item) {
        return ModUtil.makeStack(item, 1);
    }

    @Nonnull
    public static ItemStack makeStack(Item item, int stackSize) {
        return new ItemStack((IItemProvider)item, stackSize);
    }

    public static boolean isEmpty(Item item) {
        return item == Items.field_190931_a;
    }
}

