/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.helpers;

import java.util.ArrayList;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class StateLookup {
    public int getStateId(BlockState state) {
        return Block.func_196246_j((BlockState)state);
    }

    public BlockState getStateById(int blockStateID) {
        return Block.func_196257_b((int)blockStateID);
    }

    public static class CachedStateLookup
    extends StateLookup {
        private final BlockState[] states;

        public CachedStateLookup() {
            ArrayList<BlockState> list = new ArrayList<BlockState>();
            for (Block blk : ForgeRegistries.BLOCKS) {
                for (BlockState state : blk.func_176194_O().func_177619_a()) {
                    int id = ModUtil.getStateId(state);
                    list.ensureCapacity(id);
                    while (list.size() <= id) {
                        list.add(null);
                    }
                    list.set(id, state);
                }
            }
            this.states = list.toArray(new BlockState[list.size()]);
        }

        @Override
        public BlockState getStateById(int blockStateID) {
            return blockStateID >= 0 && blockStateID < this.states.length ? (this.states[blockStateID] == null ? Blocks.field_150350_a.func_176223_P() : this.states[blockStateID]) : Blocks.field_150350_a.func_176223_P();
        }
    }
}

