/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.helpers.LocalStrings;
import mod.chiselsandbits.registry.ModBlocks;
import mod.chiselsandbits.registry.ModItems;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;

@JeiPlugin
public class JustEnoughItems
implements IModPlugin {
    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<IForgeRegistryEntry> blocks = new ArrayList<IForgeRegistryEntry>();
        for (RegistryObject<ItemBlockChiseled> blk : ModBlocks.getMaterialToItemConversions().values()) {
            blocks.add(blk.get());
        }
        this.addDescription(registration, LocalStrings.LongHelpChisel, (Item)ModItems.ITEM_CHISEL_DIAMOND.get(), (Item)ModItems.ITEM_CHISEL_GOLD.get(), (Item)ModItems.ITEM_CHISEL_IRON.get(), (Item)ModItems.ITEM_CHISEL_STONE.get());
        this.addDescription(registration, LocalStrings.LongHelpChiseledBlock, blocks.toArray(new Item[0]));
        this.addDescription(registration, LocalStrings.LongHelpBitBag, (Item)ModItems.ITEM_BIT_BAG_DEFAULT.get(), (Item)ModItems.ITEM_BIT_BAG_DYED.get());
        this.addDescription(registration, LocalStrings.LongHelpBit, (Item)ModItems.ITEM_BLOCK_BIT.get());
        this.addDescription(registration, LocalStrings.LongHelpMirrorPrint, (Item)ModItems.ITEM_MIRROR_PRINT.get(), (Item)ModItems.ITEM_MIRROR_PRINT_WRITTEN.get());
        this.addDescription(registration, LocalStrings.LongHelpNegativePrint, (Item)ModItems.ITEM_NEGATIVE_PRINT.get(), (Item)ModItems.ITEM_NEGATIVE_PRINT_WRITTEN.get());
        this.addDescription(registration, LocalStrings.LongHelpPositivePrint, (Item)ModItems.ITEM_POSITIVE_PRINT.get(), (Item)ModItems.ITEM_POSITIVE_PRINT_WRITTEN.get());
        this.addDescription(registration, LocalStrings.LongHelpBitSaw, (Item)ModItems.ITEM_BIT_SAW_DIAMOND.get());
        this.addDescription(registration, LocalStrings.LongHelpTapeMeasure, (Item)ModItems.ITEM_TAPE_MEASURE.get());
        this.addDescription(registration, LocalStrings.LongHelpWrench, (Item)ModItems.ITEM_WRENCH.get());
        this.addDescription(registration, LocalStrings.LongHelpBitTank, (Item)ModBlocks.BIT_STORAGE_BLOCK_ITEM.get());
        this.addDescription(registration, LocalStrings.LongHelpMagnifyingGlass, (Item)ModItems.ITEM_MAGNIFYING_GLASS.get());
    }

    private void addDescription(IRecipeRegistration registry, LocalStrings local, Item ... items) {
        if (items.length > 0) {
            List stacks = Arrays.asList(items).stream().map(ItemStack::new).collect(Collectors.toList());
            IIngredientType itemStackIIngredientType = registry.getIngredientManager().getIngredientType(ItemStack.class);
            registry.addIngredientInfo(stacks, itemStackIIngredientType, new String[]{local.toString()});
        }
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("chiselsandbits", "jei");
    }
}

