/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.network;

import java.util.HashMap;
import java.util.function.BiConsumer;
import mod.chiselsandbits.network.ModPacket;
import mod.chiselsandbits.network.NetworkChannel;
import mod.chiselsandbits.network.packets.PacketAccurateSneakPlace;
import mod.chiselsandbits.network.packets.PacketBagGui;
import mod.chiselsandbits.network.packets.PacketBagGuiStack;
import mod.chiselsandbits.network.packets.PacketChisel;
import mod.chiselsandbits.network.packets.PacketClearBagGui;
import mod.chiselsandbits.network.packets.PacketOpenBagGui;
import mod.chiselsandbits.network.packets.PacketRotateVoxelBlob;
import mod.chiselsandbits.network.packets.PacketSetChiselMode;
import mod.chiselsandbits.network.packets.PacketSetColor;
import mod.chiselsandbits.network.packets.PacketSortBagGui;
import mod.chiselsandbits.network.packets.PacketSuppressInteraction;
import mod.chiselsandbits.network.packets.PacketUndo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum ModPacketTypes {
    CHISEL((channel, integer) -> channel.registerMessage((int)integer, PacketChisel.class, PacketChisel::new)),
    OPEN_BAG_GUI((channel, integer) -> channel.registerMessage((int)integer, PacketOpenBagGui.class, PacketOpenBagGui::new)),
    SET_CHISEL_MODE((channel, integer) -> channel.registerMessage((int)integer, PacketSetChiselMode.class, PacketSetChiselMode::new)),
    ROTATE_VOXEL_BLOB((channel, integer) -> channel.registerMessage((int)integer, PacketRotateVoxelBlob.class, PacketRotateVoxelBlob::new)),
    BAG_GUI((channel, integer) -> channel.registerMessage((int)integer, PacketBagGui.class, PacketBagGui::new)),
    BAG_GUI_STACK((channel, integer) -> channel.registerMessage((int)integer, PacketBagGuiStack.class, PacketBagGuiStack::new)),
    UNDO((channel, integer) -> channel.registerMessage((int)integer, PacketUndo.class, PacketUndo::new)),
    CLEAR_BAG((channel, integer) -> channel.registerMessage((int)integer, PacketClearBagGui.class, PacketClearBagGui::new)),
    SUPRESS_INTERACTION((channel, integer) -> channel.registerMessage((int)integer, PacketSuppressInteraction.class, PacketSuppressInteraction::new)),
    SET_COLOR((channel, integer) -> channel.registerMessage((int)integer, PacketSetColor.class, PacketSetColor::new)),
    ACCURATE_PLACEMENT((channel, integer) -> channel.registerMessage((int)integer, PacketAccurateSneakPlace.class, PacketAccurateSneakPlace::new)),
    SORT_BAG_GUI((channel, integer) -> channel.registerMessage((int)integer, PacketSortBagGui.class, PacketSortBagGui::new));

    private static final Logger LOGGER;
    private final BiConsumer<NetworkChannel, Integer> registrationHandler;
    private static HashMap<Class<? extends ModPacket>, Integer> fromClassToId;
    private static HashMap<Integer, Class<? extends ModPacket>> fromIdToClass;

    private ModPacketTypes(BiConsumer<NetworkChannel, Integer> registrationHandler) {
        this.registrationHandler = registrationHandler;
    }

    public static void init(NetworkChannel channel) {
        int idx = 0;
        for (ModPacketTypes p : ModPacketTypes.values()) {
            p.registrationHandler.accept(channel, ++idx);
        }
    }

    public static int getID(Class<? extends ModPacket> clz) {
        return fromClassToId.get(clz);
    }

    public static ModPacket constructByID(int id) throws InstantiationException, IllegalAccessException {
        return fromIdToClass.get(id).newInstance();
    }

    static {
        LOGGER = LogManager.getLogger(ModPacketTypes.class);
        fromClassToId = new HashMap();
        fromIdToClass = new HashMap();
    }
}

