/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.bit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.client.model.baked.BaseBakedBlockModel;
import mod.chiselsandbits.core.ClientSide;
import mod.chiselsandbits.render.helpers.ModelQuadLayer;
import mod.chiselsandbits.render.helpers.ModelUtil;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.Nullable;

public class BitItemBaked
extends BaseBakedBlockModel {
    public static final float PIXELS_PER_BLOCK = 16.0f;
    private static final float BIT_BEGIN = 6.0f;
    private static final float BIT_END = 10.0f;
    final ArrayList<BakedQuad> generic = new ArrayList(6);
    private static final Random RANDOM = new Random();

    public BitItemBaked(int BlockRef) {
        FaceBakery faceBakery = new FaceBakery();
        Vector3f to = new Vector3f(6.0f, 6.0f, 6.0f);
        Vector3f from = new Vector3f(10.0f, 10.0f, 10.0f);
        BlockPartRotation bpr = null;
        ModelRotation mr = ModelRotation.X0_Y0;
        for (Direction myFace : Direction.values()) {
            for (RenderType layer : RenderType.func_228661_n_()) {
                ModelQuadLayer[] layers = ModelUtil.getCachedFace(BlockRef, RANDOM, myFace, layer);
                if (layers == null || layers.length == 0) continue;
                for (ModelQuadLayer clayer : layers) {
                    Vector3f fromB;
                    Vector3f toB;
                    BlockFaceUV uv = new BlockFaceUV(this.getFaceUvs(myFace), 0);
                    BlockPartFace bpf = new BlockPartFace(myFace, 0, "", uv);
                    switch (myFace) {
                        case UP: {
                            toB = new Vector3f(to.func_195899_a(), from.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case EAST: {
                            toB = new Vector3f(from.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case NORTH: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), to.func_195902_c());
                            break;
                        }
                        case SOUTH: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), from.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case DOWN: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(from.func_195899_a(), to.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        case WEST: {
                            toB = new Vector3f(to.func_195899_a(), to.func_195900_b(), to.func_195902_c());
                            fromB = new Vector3f(to.func_195899_a(), from.func_195900_b(), from.func_195902_c());
                            break;
                        }
                        default: {
                            throw new NullPointerException();
                        }
                    }
                    this.generic.add(faceBakery.func_228824_a_(toB, fromB, bpf, clayer.sprite, myFace, (IModelTransform)mr, bpr, false, new ResourceLocation("chiselsandbits", "bit")));
                }
            }
        }
        this.generic.trimToSize();
    }

    private float[] getFaceUvs(Direction face) {
        float[] afloat;
        int from_x = 7;
        int from_y = 7;
        int from_z = 7;
        int to_x = 8;
        int to_y = 8;
        int to_z = 8;
        switch (face) {
            case UP: 
            case DOWN: {
                afloat = new float[]{7.0f, 7.0f, 8.0f, 8.0f};
                break;
            }
            case NORTH: 
            case SOUTH: {
                afloat = new float[]{7.0f, 8.0f, 8.0f, 9.0f};
                break;
            }
            case EAST: 
            case WEST: {
                afloat = new float[]{7.0f, 8.0f, 8.0f, 9.0f};
                break;
            }
            default: {
                throw new NullPointerException();
            }
        }
        return afloat;
    }

    public List<BakedQuad> func_200117_a(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        if (side != null) {
            return Collections.emptyList();
        }
        return this.generic;
    }

    public boolean func_230044_c_() {
        return true;
    }

    public TextureAtlasSprite func_177554_e() {
        return ClientSide.instance.getMissingIcon();
    }
}

