/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.render.helpers;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.DeprecationHelper;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.interfaces.ICacheClearable;
import mod.chiselsandbits.render.chiseledblock.ChiselRenderType;
import mod.chiselsandbits.render.chiseledblock.ChiseledBlockBakedModel;
import mod.chiselsandbits.render.helpers.ModelQuadLayer;
import mod.chiselsandbits.render.helpers.ModelVertexRange;
import mod.chiselsandbits.render.helpers.SimpleGeneratedModel;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ModelUtil
implements ICacheClearable {
    private static final HashMap<Pair<RenderType, Direction>, HashMap<Integer, String>> blockToTexture = new HashMap();
    private static HashMap<Triple<Integer, RenderType, Direction>, ModelQuadLayer[]> cache = new HashMap();
    private static HashMap<Pair<RenderType, Integer>, ChiseledBlockBakedModel> breakCache = new HashMap();
    private static ModelUtil instance = new ModelUtil();
    public static Random MODEL_RANDOM = new Random();

    @Override
    public void clearCache() {
        blockToTexture.clear();
        cache.clear();
        breakCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelQuadLayer[] getCachedFace(int stateID, Random weight, Direction face, RenderType layer) {
        if (layer == null) {
            return null;
        }
        Triple cacheVal = Triple.of((Object)stateID, (Object)layer, (Object)face);
        ModelQuadLayer[] mpc = cache.get(cacheVal);
        if (mpc != null) {
            return mpc;
        }
        RenderType original = MinecraftForgeClient.getRenderLayer();
        try {
            ForgeHooksClient.setRenderLayer((RenderType)layer);
            ModelQuadLayer[] modelQuadLayerArray = ModelUtil.getInnerCachedFace((Triple<Integer, RenderType, Direction>)cacheVal, stateID, weight, face, layer);
            return modelQuadLayerArray;
        }
        finally {
            ForgeHooksClient.setRenderLayer((RenderType)original);
        }
    }

    private static ModelQuadLayer[] getInnerCachedFace(Triple<Integer, RenderType, Direction> cacheVal, int stateID, Random weight, Direction face, RenderType layer) {
        BlockState state = ModUtil.getStateById(stateID);
        IBakedModel model = ModelUtil.solveModel(state, weight, Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(state), layer);
        int lv = (Boolean)ChiselsAndBits.getConfig().getClient().useGetLightValue.get() != false ? DeprecationHelper.getLightValue(state) : 0;
        Fluid fluid = BlockBitInfo.getFluidFromBlock(state.func_177230_c());
        if (fluid != null) {
            for (Direction xf : Direction.values()) {
                ModelQuadLayer[] mp = new ModelQuadLayer[]{new ModelQuadLayer()};
                mp[0].color = fluid.getAttributes().getColor();
                mp[0].light = lv;
                float V = 0.5f;
                float Uf = 1.0f;
                float U = 0.5f;
                float Vf = 1.0f;
                if (xf.func_176740_k() == Direction.Axis.Y) {
                    mp[0].sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluid.getAttributes().getStillTexture());
                    mp[0].uvs = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
                } else if (xf.func_176740_k() == Direction.Axis.X) {
                    mp[0].sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluid.getAttributes().getFlowingTexture());
                    mp[0].uvs = new float[]{0.5f, 0.0f, 0.5f, 0.5f, 0.0f, 0.0f, 0.0f, 0.5f};
                } else {
                    mp[0].sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(fluid.getAttributes().getFlowingTexture());
                    mp[0].uvs = new float[]{0.5f, 0.0f, 0.0f, 0.0f, 0.5f, 0.5f, 0.0f, 0.5f};
                }
                mp[0].tint = 0;
                Triple k = Triple.of((Object)stateID, (Object)layer, (Object)xf);
                cache.put((Triple<Integer, RenderType, Direction>)k, mp);
            }
            return cache.get(cacheVal);
        }
        HashMap<Direction, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>> tmp = new HashMap<Direction, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>>();
        int color = BlockBitInfo.getColorFor(state, 0);
        for (Direction f : Direction.values()) {
            tmp.put(f, new ArrayList());
        }
        if (model != null) {
            for (Direction f : Direction.values()) {
                List<BakedQuad> quads = ModelUtil.getModelQuads(model, state, f, MODEL_RANDOM);
                ModelUtil.processFaces(tmp, quads, state);
            }
            ModelUtil.processFaces(tmp, ModelUtil.getModelQuads(model, state, null, MODEL_RANDOM), state);
        }
        for (Direction f : Direction.values()) {
            Triple k = Triple.of((Object)stateID, (Object)layer, (Object)f);
            ArrayList<ModelQuadLayer.ModelQuadLayerBuilder> x = tmp.get(f);
            ModelQuadLayer[] mp = new ModelQuadLayer[x.size()];
            for (int z = 0; z < x.size(); ++z) {
                mp[z] = x.get(z).build(stateID, color, lv);
            }
            cache.put((Triple<Integer, RenderType, Direction>)k, mp);
        }
        return cache.get(cacheVal);
    }

    private static List<BakedQuad> getModelQuads(IBakedModel model, BlockState state, Direction f, Random rand) {
        try {
            return model.func_200117_a(state, f, rand);
        }
        catch (Throwable throwable) {
            try {
                return model.func_200117_a(null, f, rand);
            }
            catch (Throwable throwable2) {
                IBakedModel secondModel;
                ItemStack is = ModUtil.getItemStackFromBlockState(state);
                if (!ModUtil.isEmpty(is) && (secondModel = ModelUtil.getOverrides(model).func_239290_a_(model, is, Minecraft.func_71410_x().field_71441_e, (LivingEntity)Minecraft.func_71410_x().field_71439_g)) != null) {
                    try {
                        return secondModel.func_200117_a(null, f, rand);
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                return Collections.emptyList();
            }
        }
    }

    private static ItemOverrideList getOverrides(IBakedModel model) {
        if (model != null) {
            ItemOverrideList modelOverrides = model.func_188617_f();
            return modelOverrides == null ? ItemOverrideList.field_188022_a : modelOverrides;
        }
        return ItemOverrideList.field_188022_a;
    }

    private static void processFaces(HashMap<Direction, ArrayList<ModelQuadLayer.ModelQuadLayerBuilder>> tmp, List<BakedQuad> quads, BlockState state) {
        for (BakedQuad q : quads) {
            Direction face = q.func_178210_d();
            if (face == null) continue;
            try {
                TextureAtlasSprite sprite = ModelUtil.findQuadTexture(q, state);
                ArrayList<ModelQuadLayer.ModelQuadLayerBuilder> l = tmp.get(face);
                ModelQuadLayer.ModelQuadLayerBuilder b = null;
                for (ModelQuadLayer.ModelQuadLayerBuilder lx : l) {
                    if (lx.cache.sprite != sprite) continue;
                    b = lx;
                    break;
                }
                if (b == null) {
                    int uCoord = 0;
                    int vCoord = 2;
                    switch (face) {
                        case NORTH: 
                        case SOUTH: {
                            uCoord = 0;
                            vCoord = 1;
                            break;
                        }
                        case EAST: 
                        case WEST: {
                            uCoord = 1;
                            vCoord = 2;
                            break;
                        }
                    }
                    b = new ModelQuadLayer.ModelQuadLayerBuilder(sprite, uCoord, vCoord);
                    b.cache.tint = q.func_178211_c();
                    l.add(b);
                }
                q.pipe((IVertexConsumer)b.uvr);
                if (!((Boolean)ChiselsAndBits.getConfig().getClient().enableFaceLightmapExtraction.get()).booleanValue()) continue;
                b.lv.setVertexFormat(DefaultVertexFormats.field_176600_a);
                q.pipe((IVertexConsumer)b.lv);
            }
            catch (Exception exception) {}
        }
    }

    private ModelUtil() {
        ChiselsAndBits.getInstance().addClearable(this);
    }

    public static TextureAtlasSprite findQuadTexture(BakedQuad q, BlockState state) throws IllegalArgumentException, IllegalAccessException, NullPointerException {
        if (q.field_187509_d == null) {
            return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation("missingno"));
        }
        return q.field_187509_d;
    }

    public static IBakedModel solveModel(BlockState state, Random weight, IBakedModel originalModel, RenderType layer) {
        ItemStack is;
        boolean hasFaces = false;
        try {
            hasFaces = ModelUtil.hasFaces(originalModel, state, null, weight);
            for (Direction f : Direction.values()) {
                hasFaces = hasFaces || ModelUtil.hasFaces(originalModel, state, f, weight);
            }
        }
        catch (Exception e) {
            hasFaces = false;
        }
        if (!hasFaces && !ModUtil.isEmpty(is = ModUtil.getItemStackFromBlockState(state))) {
            IBakedModel itemModel = Minecraft.func_71410_x().func_175599_af().func_184393_a(is, (World)Minecraft.func_71410_x().field_71441_e, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
            try {
                hasFaces = ModelUtil.hasFaces(originalModel, state, null, weight);
                for (Direction f : Direction.values()) {
                    hasFaces = hasFaces || ModelUtil.hasFaces(originalModel, state, f, weight);
                }
            }
            catch (Exception e) {
                hasFaces = false;
            }
            if (hasFaces) {
                return itemModel;
            }
            return new SimpleGeneratedModel(ModelUtil.findTexture(Block.func_196246_j((BlockState)state), originalModel, Direction.UP, layer, weight));
        }
        return originalModel;
    }

    private static boolean hasFaces(IBakedModel model, BlockState state, Direction f, Random weight) {
        List<BakedQuad> l = ModelUtil.getModelQuads(model, state, f, weight);
        if (l == null || l.isEmpty()) {
            return false;
        }
        TextureAtlasSprite texture = null;
        try {
            texture = ModelUtil.findTexture(null, l, f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModelVertexRange mvr = new ModelVertexRange();
        for (BakedQuad q : l) {
            q.pipe((IVertexConsumer)mvr);
        }
        return mvr.getLargestRange() > 0.0f && !ModelUtil.isMissing(texture);
    }

    private static boolean isMissing(TextureAtlasSprite texture) {
        return texture == null || texture == Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation("missingno"));
    }

    public static TextureAtlasSprite findTexture(int BlockRef, IBakedModel model, Direction myFace, RenderType layer, Random random) {
        if (blockToTexture.getOrDefault(Pair.of((Object)layer, (Object)myFace), Maps.newHashMap()).containsKey(BlockRef)) {
            String textureName = blockToTexture.get(Pair.of((Object)layer, (Object)myFace)).get(BlockRef);
            return (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation(textureName));
        }
        TextureAtlasSprite texture = null;
        BlockState state = ModUtil.getStateById(BlockRef);
        if (model != null) {
            try {
                texture = ModelUtil.findTexture(texture, ModelUtil.getModelQuads(model, state, myFace, random), myFace);
                if (texture == null) {
                    for (Direction side : Direction.values()) {
                        texture = ModelUtil.findTexture(texture, ModelUtil.getModelQuads(model, state, side, random), side);
                    }
                    texture = ModelUtil.findTexture(texture, ModelUtil.getModelQuads(model, state, null, random), null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ModelUtil.isMissing(texture)) {
            try {
                if (model != null) {
                    texture = model.func_177554_e();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (ModelUtil.isMissing(texture)) {
            try {
                texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture == null) {
            texture = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(new ResourceLocation("missingno"));
        }
        blockToTexture.remove(Pair.of((Object)layer, (Object)myFace), null);
        blockToTexture.putIfAbsent((Pair<RenderType, Direction>)Pair.of((Object)layer, (Object)myFace), Maps.newHashMap());
        blockToTexture.get(Pair.of((Object)layer, (Object)myFace)).put(BlockRef, texture.func_195668_m().toString());
        return texture;
    }

    private static TextureAtlasSprite findTexture(TextureAtlasSprite texture, List<BakedQuad> faceQuads, Direction myFace) throws IllegalArgumentException, IllegalAccessException, NullPointerException {
        for (BakedQuad q : faceQuads) {
            if (q.func_178210_d() != myFace) continue;
            texture = ModelUtil.findQuadTexture(q, null);
        }
        return texture;
    }

    public static boolean isOne(float v) {
        return (double)Math.abs(v) < 0.01;
    }

    public static boolean isZero(float v) {
        return (double)Math.abs(v - 1.0f) < 0.01;
    }

    public static Integer getItemStackColor(ItemStack target, int tint) {
        if (ModUtil.isEmpty(target)) {
            return -1;
        }
        return Minecraft.func_71410_x().getItemColors().func_186728_a(target, tint);
    }

    public static ChiseledBlockBakedModel getBreakingModel(ChiselRenderType layer, Integer blockStateID, Random random) {
        Pair key = Pair.of((Object)layer.layer, (Object)blockStateID);
        ChiseledBlockBakedModel out = breakCache.get(key);
        if (out == null) {
            BlockState state = ModUtil.getStateById(blockStateID);
            IBakedModel model = ModelUtil.solveModel(state, random, Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(ModUtil.getStateById(blockStateID)), layer.layer);
            out = model != null ? ChiseledBlockBakedModel.createFromTexture(ModelUtil.findTexture(blockStateID, model, Direction.UP, layer.layer, random), layer) : ChiseledBlockBakedModel.createFromTexture(null, null);
            breakCache.put((Pair<RenderType, Integer>)key, out);
        }
        return out;
    }
}

