/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public final class FluidCuboidHelper {
    private FluidCuboidHelper() {
        throw new IllegalStateException("Tried to initialize: FluidCuboidHelper but this is a Utility class.");
    }

    public static void renderScaledFluidCuboid(FluidStack fluid, MatrixStack matrices, IVertexBuilder renderer, int combinedLight, int combinedOverlay, float x1, float y1, float z1, float x2, float y2, float z2) {
        FluidCuboidHelper.renderFluidCuboid(fluid, matrices, renderer, combinedLight, combinedOverlay, x1 / 16.0f, y1 / 16.0f, z1 / 16.0f, x2 / 16.0f, y2 / 16.0f, z2 / 16.0f);
    }

    public static void renderFluidCuboid(FluidStack fluid, MatrixStack matrices, IVertexBuilder renderer, int combinedLight, int combinedOverlay, float x1, float y1, float z1, float x2, float y2, float z2) {
        int color = fluid.getFluid().getAttributes().getColor(fluid);
        FluidCuboidHelper.renderFluidCuboid(fluid, matrices, renderer, combinedLight, combinedOverlay, x1, y1, z1, x2, y2, z2, color);
    }

    public static void renderFluidCuboid(FluidStack fluid, MatrixStack matrices, IVertexBuilder renderer, int combinedLight, int combinedOverlay, float x1, float y1, float z1, float x2, float y2, float z2, int color) {
        TextureAtlasSprite still = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getFluid().getAttributes().getStillTexture(fluid));
        TextureAtlasSprite flowing = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(fluid.getFluid().getAttributes().getFlowingTexture(fluid));
        FluidCuboidHelper.renderFluidCuboid(still, flowing, color, matrices, renderer, combinedOverlay, combinedLight, x1, y1, z1, x2, y2, z2);
    }

    public static void renderFluidCuboid(TextureAtlasSprite still, TextureAtlasSprite flowing, int color, MatrixStack matrices, IVertexBuilder renderer, int combinedOverlay, int combinedLight, float x1, float y1, float z1, float x2, float y2, float z2) {
        matrices.func_227860_a_();
        matrices.func_227861_a_((double)x1, (double)y1, (double)z1);
        FluidCuboidHelper.putTexturedQuad(renderer, matrices.func_227866_c_(), still, x2 - x1, y2 - y1, z2 - z1, Direction.DOWN, color, combinedOverlay, combinedLight, false);
        FluidCuboidHelper.putTexturedQuad(renderer, matrices.func_227866_c_(), flowing, x2 - x1, y2 - y1, z2 - z1, Direction.NORTH, color, combinedOverlay, combinedLight, true);
        FluidCuboidHelper.putTexturedQuad(renderer, matrices.func_227866_c_(), flowing, x2 - x1, y2 - y1, z2 - z1, Direction.EAST, color, combinedOverlay, combinedLight, true);
        FluidCuboidHelper.putTexturedQuad(renderer, matrices.func_227866_c_(), flowing, x2 - x1, y2 - y1, z2 - z1, Direction.SOUTH, color, combinedOverlay, combinedLight, true);
        FluidCuboidHelper.putTexturedQuad(renderer, matrices.func_227866_c_(), flowing, x2 - x1, y2 - y1, z2 - z1, Direction.WEST, color, combinedOverlay, combinedLight, true);
        FluidCuboidHelper.putTexturedQuad(renderer, matrices.func_227866_c_(), still, x2 - x1, y2 - y1, z2 - z1, Direction.UP, color, combinedOverlay, combinedLight, false);
        matrices.func_227865_b_();
    }

    public static void putTexturedQuad(IVertexBuilder renderer, MatrixStack.Entry matrix, TextureAtlasSprite sprite, float w, float h, float d, Direction face, int color, int overlay, int brightness, boolean flowing) {
        FluidCuboidHelper.putTexturedQuad(renderer, matrix, sprite, w, h, d, face, color, overlay, brightness, flowing, false, false);
    }

    public static void putTexturedQuad(IVertexBuilder renderer, MatrixStack.Entry matrix, TextureAtlasSprite sprite, float w, float h, float d, Direction face, int color, int overlay, int brightness, boolean flowing, boolean flipHorizontally, boolean flipVertically) {
        int l1 = brightness >> 16 & 0xFFFF;
        int l2 = brightness & 0xFFFF;
        int o1 = overlay >> 16 & 0xFFFF;
        int o2 = overlay & 0xFFFF;
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        FluidCuboidHelper.putTexturedQuad(renderer, matrix, sprite, w, h, d, face, r, g, b, a, l1, l2, o1, o2, flowing, flipHorizontally, flipVertically);
    }

    public static void putTexturedQuad(IVertexBuilder renderer, MatrixStack.Entry matrices, TextureAtlasSprite sprite, float w, float h, float d, Direction face, int r, int g, int b, int a, int light1, int light2, int overlay1, int overlay2, boolean flowing, boolean flipHorizontally, boolean flipVertically) {
        float maxV;
        float minV;
        float maxU;
        float minU;
        double zt2;
        double yt2;
        double xt2;
        if (sprite == null) {
            return;
        }
        double size = 16.0;
        if (flowing) {
            size = 8.0;
        }
        double xt1 = 0.0;
        for (xt2 = (double)w; xt2 > 1.0; xt2 -= 1.0) {
        }
        double yt1 = 0.0;
        for (yt2 = (double)h; yt2 > 1.0; yt2 -= 1.0) {
        }
        double zt1 = 0.0;
        for (zt2 = (double)d; zt2 > 1.0; zt2 -= 1.0) {
        }
        if (flowing) {
            double tmp = 1.0 - yt1;
            yt1 = 1.0 - yt2;
            yt2 = tmp;
        }
        switch (face) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(xt1 * size);
                maxU = sprite.func_94214_a(xt2 * size);
                minV = sprite.func_94207_b(zt1 * size);
                maxV = sprite.func_94207_b(zt2 * size);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(xt2 * size);
                maxU = sprite.func_94214_a(xt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(zt2 * size);
                maxU = sprite.func_94214_a(zt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        if (flipHorizontally) {
            float tmp = minV;
            minV = maxV;
            maxV = tmp;
        }
        if (flipVertically) {
            float tmp = minU;
            minU = maxU;
            maxU = tmp;
        }
        Matrix4f worldMatrix = matrices.func_227870_a_();
        Matrix3f normalMatrix = matrices.func_227872_b_();
        switch (face) {
            case DOWN: {
                renderer.func_227888_a_(worldMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.DOWN.func_82601_c(), (float)Direction.DOWN.func_96559_d(), (float)Direction.DOWN.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.DOWN.func_82601_c(), (float)Direction.DOWN.func_96559_d(), (float)Direction.DOWN.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, 0.0f, d).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.DOWN.func_82601_c(), (float)Direction.DOWN.func_96559_d(), (float)Direction.DOWN.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, 0.0f, 0.0f, d).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.DOWN.func_82601_c(), (float)Direction.DOWN.func_96559_d(), (float)Direction.DOWN.func_82599_e()).func_181675_d();
                break;
            }
            case UP: {
                renderer.func_227888_a_(worldMatrix, 0.0f, h, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.UP.func_82601_c(), (float)Direction.UP.func_96559_d(), (float)Direction.UP.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, 0.0f, h, d).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.UP.func_82601_c(), (float)Direction.UP.func_96559_d(), (float)Direction.UP.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, h, d).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.UP.func_82601_c(), (float)Direction.UP.func_96559_d(), (float)Direction.UP.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, h, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.UP.func_82601_c(), (float)Direction.UP.func_96559_d(), (float)Direction.UP.func_82599_e()).func_181675_d();
                break;
            }
            case NORTH: {
                renderer.func_227888_a_(worldMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.NORTH.func_82601_c(), (float)Direction.NORTH.func_96559_d(), (float)Direction.NORTH.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, 0.0f, h, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.NORTH.func_82601_c(), (float)Direction.NORTH.func_96559_d(), (float)Direction.NORTH.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, h, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.NORTH.func_82601_c(), (float)Direction.NORTH.func_96559_d(), (float)Direction.NORTH.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.NORTH.func_82601_c(), (float)Direction.NORTH.func_96559_d(), (float)Direction.NORTH.func_82599_e()).func_181675_d();
                break;
            }
            case SOUTH: {
                renderer.func_227888_a_(worldMatrix, 0.0f, 0.0f, d).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.SOUTH.func_82601_c(), (float)Direction.SOUTH.func_96559_d(), (float)Direction.SOUTH.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, 0.0f, d).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.SOUTH.func_82601_c(), (float)Direction.SOUTH.func_96559_d(), (float)Direction.SOUTH.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, h, d).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.SOUTH.func_82601_c(), (float)Direction.SOUTH.func_96559_d(), (float)Direction.SOUTH.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, 0.0f, h, d).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.SOUTH.func_82601_c(), (float)Direction.SOUTH.func_96559_d(), (float)Direction.SOUTH.func_82599_e()).func_181675_d();
                break;
            }
            case WEST: {
                renderer.func_227888_a_(worldMatrix, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.WEST.func_82601_c(), (float)Direction.WEST.func_96559_d(), (float)Direction.WEST.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, 0.0f, 0.0f, d).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.WEST.func_82601_c(), (float)Direction.WEST.func_96559_d(), (float)Direction.WEST.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, 0.0f, h, d).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.WEST.func_82601_c(), (float)Direction.WEST.func_96559_d(), (float)Direction.WEST.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, 0.0f, h, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.WEST.func_82601_c(), (float)Direction.WEST.func_96559_d(), (float)Direction.WEST.func_82599_e()).func_181675_d();
                break;
            }
            case EAST: {
                renderer.func_227888_a_(worldMatrix, w, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.EAST.func_82601_c(), (float)Direction.EAST.func_96559_d(), (float)Direction.EAST.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, h, 0.0f).func_225586_a_(r, g, b, a).func_225583_a_(minU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.EAST.func_82601_c(), (float)Direction.EAST.func_96559_d(), (float)Direction.EAST.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, h, d).func_225586_a_(r, g, b, a).func_225583_a_(maxU, minV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.EAST.func_82601_c(), (float)Direction.EAST.func_96559_d(), (float)Direction.EAST.func_82599_e()).func_181675_d();
                renderer.func_227888_a_(worldMatrix, w, 0.0f, d).func_225586_a_(r, g, b, a).func_225583_a_(maxU, maxV).func_225585_a_(overlay1, overlay2).func_225587_b_(light1, light2).func_227887_a_(normalMatrix, (float)Direction.EAST.func_82601_c(), (float)Direction.EAST.func_96559_d(), (float)Direction.EAST.func_82599_e()).func_181675_d();
            }
        }
    }
}

