/*
 * Decompiled with CFR 0.152.
 */
package com.nekomaster1000.infernalexp.entities;

import com.nekomaster1000.infernalexp.entities.ai.ShroomloinSwellGoal;
import com.nekomaster1000.infernalexp.util.RegistryHandler;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShroomloinEntity
extends MonsterEntity {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(ShroomloinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(ShroomloinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 30;

    public ShroomloinEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233824_g_, 2.0).func_233815_a_(Attributes.field_233821_d_, 0.6);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            if (this.func_70644_a(Effect.func_188412_a((int)19))) {
                this.func_184596_c(Effect.func_188412_a((int)19));
            }
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setShroomloinState(1);
            }
            if ((i = this.getShroomloinState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new ShroomloinSwellGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 0.6, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.5));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getShroomloinFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getShroomloinState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setShroomloinState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    private void explode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70729_aU = true;
            this.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 0.5f);
            this.spawnExplosionCloud();
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    private void spawnExplosionCloud() {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.6, this.func_226281_cx_());
        areaeffectcloudentity.func_184483_a(3.0f);
        areaeffectcloudentity.func_184485_d(0);
        areaeffectcloudentity.func_184486_b(10);
        areaeffectcloudentity.func_184487_c(0.0f);
        areaeffectcloudentity.func_184484_a(Potion.func_185168_a((String)"strong_poison"));
        areaeffectcloudentity.func_195059_a((IParticleData)ParticleTypes.field_197627_t);
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    private void spawnLingeringCloud() {
        AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        areaeffectcloudentity.func_184483_a(6.0f);
        areaeffectcloudentity.func_184495_b(-0.5f);
        areaeffectcloudentity.func_184485_d(10);
        areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
        areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
        areaeffectcloudentity.func_184484_a(Potion.func_185168_a((String)"long_poison"));
        areaeffectcloudentity.func_184482_a(16747326);
        this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void becomeAngryAt(LivingEntity entity) {
        this.func_70624_b(entity);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(4);
    }

    protected SoundEvent func_184639_G() {
        return RegistryHandler.shroomloin_ambient;
    }

    protected SoundEvent func_184615_bR() {
        return RegistryHandler.shroomloin_death;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RegistryHandler.shroomloin_hurt;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }
}

