/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.jeiprofessions;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.AbstractBlock;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public final class ProfessionEntry {
    final VillagerProfession profession;
    final String nameKey;
    final List<List<ItemStack>> inputs;

    private ProfessionEntry(VillagerProfession profession, String nameKey, List<List<ItemStack>> inputs) {
        this.profession = profession;
        this.nameKey = nameKey;
        this.inputs = inputs;
    }

    public VillagerProfession get() {
        return this.profession;
    }

    public String getName() {
        return I18n.func_135052_a((String)this.nameKey, (Object[])new Object[0]);
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public boolean hasJobSites() {
        return !this.inputs.get(0).isEmpty();
    }

    public static ProfessionEntry of(VillagerProfession profession) {
        ResourceLocation name = Objects.requireNonNull(profession.getRegistryName(), "profession name");
        String nameKey = I18n.func_135052_a((String)(EntityType.field_200756_av.func_210760_d() + '.' + ("minecraft".equals(name.func_110624_b()) ? "" : name.func_110624_b() + '.') + name.func_110623_a()), (Object[])new Object[0]);
        Set jobSites = (Set)Objects.requireNonNull(ObfuscationReflectionHelper.getPrivateValue(PointOfInterestType.class, (Object)profession.func_221149_b(), (String)"field_221075_w"), "job sites");
        List<List<ItemStack>> inputs = Collections.singletonList(jobSites.stream().map(AbstractBlock.AbstractBlockState::func_177230_c).distinct().map(ItemStack::new).collect(Collectors.toList()));
        return new ProfessionEntry(profession, nameKey, inputs);
    }
}

