/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.jeiprofessions;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import me.paulf.jeiprofessions.ProfessionEntry;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillagerProfessionCategory
implements IRecipeCategory<ProfessionEntry> {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation UID = new ResourceLocation("villager_professions");
    private static final ResourceLocation GUI = new ResourceLocation("jeiprofessions", "textures/gui/profession.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<ProfessionEntry, CachedVillager> cache = CacheBuilder.newBuilder().maximumSize(128L).expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(notification -> ((CachedVillager)notification.getValue()).remove()).build(CacheLoader.from(p -> {
        try {
            if (p == null) {
                throw new NullPointerException("profession");
            }
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientWorld world = minecraft.field_71441_e;
            if (world == null) {
                throw new NullPointerException("world");
            }
            VillagerEntity villager = (VillagerEntity)EntityType.field_200756_av.func_200721_a((World)world);
            if (villager == null) {
                throw new NullPointerException("villager");
            }
            villager.func_213753_a(villager.func_213700_eh().func_221126_a(p.get()));
            return new CachedState(new CachedVillagerEntity(villager, Util.func_211177_b()));
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            LOGGER.warn("Error creating render villager", t);
            return new CachedVillagerError(t);
        }
    }));

    public VillagerProfessionCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(GUI, 0, 0, 84, 51);
        this.icon = helper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Items.field_222109_pP));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends ProfessionEntry> getRecipeClass() {
        return ProfessionEntry.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"gui.jeiprofessions.category.villager_professions", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(ProfessionEntry profession, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, profession.getInputs());
    }

    public void setRecipe(IRecipeLayout layout, ProfessionEntry profession, IIngredients ingredients) {
        layout.getItemStacks().init(0, true, 0, 22);
        layout.getItemStacks().set(ingredients);
    }

    public void draw(ProfessionEntry profession, MatrixStack stack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        int nameX = (this.background.getWidth() - minecraft.field_71466_p.func_78256_a(profession.getName())) / 2;
        minecraft.field_71466_p.func_238421_b_(stack, profession.getName(), (float)nameX, 0.0f, -8355712);
        ((CachedVillager)this.cache.getUnchecked((Object)profession)).render(stack);
    }

    public List<ITextComponent> getTooltipStrings(ProfessionEntry profession, double mouseX, double mouseY) {
        if (this.isOverEntity(mouseX, mouseY)) {
            ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
            ((CachedVillager)this.cache.getUnchecked((Object)profession)).tooltip(tooltip);
            return tooltip;
        }
        return Collections.emptyList();
    }

    public boolean handleClick(ProfessionEntry profession, double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isOverEntity(mouseX, mouseY)) {
            ((CachedVillager)this.cache.getUnchecked((Object)profession)).press();
        }
        return false;
    }

    private boolean isOverEntity(double mouseX, double mouseY) {
        return mouseX >= 57.0 && mouseX < 83.0 && mouseY >= 12.0 && mouseY < 50.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawEntity(MatrixStack stack, int posX, int posY, int scale, LivingEntity living) {
        stack.func_227860_a_();
        stack.func_227861_a_((double)posX, (double)posY, 1050.0);
        stack.func_227866_c_().func_227870_a_().func_226595_a_(Matrix4f.func_226593_a_((float)1.0f, (float)1.0f, (float)-1.0f));
        stack.func_227861_a_(0.0, 0.0, 1000.0);
        stack.func_227862_a_((float)scale, (float)scale, (float)scale);
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        living.field_70761_aq = living.field_70177_z = 180.0f - (float)Util.func_211177_b() / 20.0f;
        living.field_70125_A = -5.0f;
        living.field_70759_as = living.field_70177_z;
        living.field_70758_at = living.field_70177_z;
        EntityRendererManager renderer = Minecraft.func_71410_x().func_175598_ae();
        renderer.func_229089_a_(Quaternion.field_227060_a_);
        renderer.func_178633_a(false);
        IRenderTypeBuffer.Impl buf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        try {
            RenderSystem.runAsFancy(() -> renderer.func_229084_a_((Entity)living, 0.0, 0.0, 0.0, 0.0f, 1.0f, stack, (IRenderTypeBuffer)buf, 0xF000F0));
        }
        finally {
            buf.func_228461_a_();
            renderer.func_178633_a(true);
            stack.func_227865_b_();
        }
    }

    static class CachedVillagerError
    implements CachedVillager {
        final Throwable error;

        CachedVillagerError(Throwable error) {
            this.error = error;
        }

        @Override
        public void render(MatrixStack stack) {
            Minecraft.func_71410_x().field_71466_p.func_243246_a(stack, (ITextComponent)new StringTextComponent(":(").func_240699_a_(TextFormatting.BOLD), 66.0f, 27.0f, -6275008);
        }

        @Override
        public void remove() {
        }

        @Override
        public void tooltip(List<ITextComponent> lines) {
            lines.add((ITextComponent)new TranslationTextComponent("jeiprofessions.error").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD}));
            lines.add((ITextComponent)new TranslationTextComponent("jeiprofessions.log").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.ITALIC}));
        }

        @Override
        public void press() {
        }
    }

    static class CachedVillagerEntity
    implements CachedVillager {
        final VillagerEntity entity;
        final long creationTime;
        long soundTime;

        CachedVillagerEntity(VillagerEntity entity, long creationTime) {
            this.entity = entity;
            this.creationTime = creationTime;
        }

        @Override
        public void render(MatrixStack stack) {
            VillagerProfessionCategory.drawEntity(stack, 70, 48, 16, (LivingEntity)this.entity);
            long now = Util.func_211177_b();
            if (now - this.creationTime > 600000L) {
                Random rng;
                long t = now / 50L;
                if (this.soundTime == 0L) {
                    this.soundTime = t;
                }
                if ((long)(rng = this.entity.func_70681_au()).nextInt(1000) < t - this.soundTime) {
                    this.soundTime = t + 80L;
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)SoundEvents.field_187910_gj, (float)((rng.nextFloat() - rng.nextFloat()) * 0.2f + 1.0f), (float)1.0f));
                }
            }
        }

        @Override
        public void remove() {
            this.entity.remove(false);
        }

        @Override
        public void tooltip(List<ITextComponent> lines) {
            lines.add(this.entity.func_145748_c_());
        }

        @Override
        public void press() {
        }
    }

    static class CachedState
    implements CachedVillager {
        CachedVillager state;

        CachedState(CachedVillager state) {
            this.state = state;
        }

        @Override
        public void render(MatrixStack stack) {
            try {
                this.state.render(stack);
            }
            catch (Throwable t) {
                Throwables.throwIfInstanceOf((Throwable)t, Error.class);
                LOGGER.warn("Error rendering", t);
                this.state = new CachedVillagerError(t);
            }
        }

        @Override
        public void remove() {
            this.state.remove();
        }

        @Override
        public void tooltip(List<ITextComponent> lines) {
            this.state.tooltip(lines);
        }

        @Override
        public void press() {
            this.state.press();
        }
    }

    static interface CachedVillager {
        public void render(MatrixStack var1);

        public void remove();

        public void tooltip(List<ITextComponent> var1);

        public void press();
    }
}

