/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.block.mushroomblocks;

import cech12.extendedmushrooms.block.mushroomblocks.MushroomCapBlock;
import cech12.extendedmushrooms.item.MushroomType;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractEffectMushroomCap
extends MushroomCapBlock {
    public static final BooleanProperty PERSISTENT = BlockStateProperties.field_208515_s;

    public AbstractEffectMushroomCap(MushroomType type, AbstractBlock.Properties properties) {
        super(type, properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    protected abstract List<EffectInstance> getEffects(@Nonnull Random var1);

    protected boolean shouldDropEffectCloud(BlockState state, @Nonnull ServerWorld world, @Nonnull BlockPos pos, @Nonnull Random random) {
        return random.nextDouble() < 0.05;
    }

    protected int getEffectCloudColor(List<EffectInstance> effects, @Nonnull Random random) {
        return PotionUtils.func_185181_a(effects);
    }

    protected float getEffectCloudRadius(@Nonnull Random random) {
        return 1.5f + random.nextFloat() * 0.5f;
    }

    protected float getEffectCloudRadiusOnUse(@Nonnull Random random) {
        return 0.4f + random.nextFloat() * 0.2f;
    }

    protected int getEffectCloudDuration(@Nonnull Random random) {
        return 600 + random.nextInt(600);
    }

    public void func_225542_b_(BlockState state, @Nonnull ServerWorld worldIn, @Nonnull BlockPos pos, @Nonnull Random random) {
        BlockPos down;
        BlockPos.Mutable effectPos;
        if (!((Boolean)state.func_177229_b((Property)PERSISTENT)).booleanValue() && this.shouldDropEffectCloud(state, worldIn, pos, random) && !worldIn.func_180495_p((BlockPos)(effectPos = new BlockPos.Mutable((down = pos.func_177977_b()).func_177958_n(), down.func_177956_o(), down.func_177952_p()))).func_200132_m()) {
            do {
                effectPos.func_189536_c(Direction.DOWN);
            } while (!worldIn.func_180495_p((BlockPos)effectPos).func_200132_m() && effectPos.func_177956_o() >= 0);
            if (effectPos.func_177956_o() >= 0) {
                effectPos.func_189536_c(Direction.UP);
                this.spawnEffectCloud(worldIn, (BlockPos)effectPos, random);
            }
        }
    }

    protected void spawnEffectCloud(@Nonnull ServerWorld worldIn, @Nonnull BlockPos pos, @Nonnull Random random) {
        List<EffectInstance> effects = this.getEffects(random);
        if (!effects.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity((World)worldIn, (double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o(), (double)pos.func_177952_p() + random.nextDouble());
            areaeffectcloudentity.func_184481_a(null);
            areaeffectcloudentity.func_184486_b(this.getEffectCloudDuration(random));
            areaeffectcloudentity.func_184483_a(this.getEffectCloudRadius(random));
            areaeffectcloudentity.func_184495_b(-this.getEffectCloudRadiusOnUse(random));
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            areaeffectcloudentity.func_184482_a(this.getEffectCloudColor(effects, random));
            for (EffectInstance effectinstance : effects) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            worldIn.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)PERSISTENT) == false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{PERSISTENT});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)PERSISTENT, (Comparable)Boolean.valueOf(true));
    }
}

