/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.client.renderer.tileentity;

import cech12.extendedmushrooms.item.MushroomWoodType;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public abstract class AbstractVariantChestTileEntityRenderer<T extends ChestTileEntity>
extends TileEntityRenderer<T> {
    private static final HashMap<MushroomWoodType, ChestTextures> TEXTURES = new HashMap();
    private final ModelRenderer field_228862_a_;
    private final ModelRenderer field_228863_c_ = new ModelRenderer(64, 64, 0, 19);
    private final ModelRenderer field_228864_d_;
    private final ModelRenderer field_228865_e_;
    private final ModelRenderer field_228866_f_;
    private final ModelRenderer field_228867_g_;
    private final ModelRenderer field_228868_h_;
    private final ModelRenderer field_228869_i_;
    private final ModelRenderer field_228870_j_;

    public AbstractVariantChestTileEntityRenderer(TileEntityRendererDispatcher p_i226008_1_) {
        super(p_i226008_1_);
        this.field_228863_c_.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.field_228862_a_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228862_a_.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.field_228862_a_.field_78797_d = 9.0f;
        this.field_228862_a_.field_78798_e = 1.0f;
        this.field_228864_d_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228864_d_.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.field_228864_d_.field_78797_d = 8.0f;
        this.field_228866_f_ = new ModelRenderer(64, 64, 0, 19);
        this.field_228866_f_.func_228301_a_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.field_228865_e_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228865_e_.func_228301_a_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.field_228865_e_.field_78797_d = 9.0f;
        this.field_228865_e_.field_78798_e = 1.0f;
        this.field_228867_g_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228867_g_.func_228301_a_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.field_228867_g_.field_78797_d = 8.0f;
        this.field_228869_i_ = new ModelRenderer(64, 64, 0, 19);
        this.field_228869_i_.func_228301_a_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.field_228868_h_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228868_h_.func_228301_a_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.field_228868_h_.field_78797_d = 9.0f;
        this.field_228868_h_.field_78798_e = 1.0f;
        this.field_228870_j_ = new ModelRenderer(64, 64, 0, 0);
        this.field_228870_j_.func_228301_a_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.field_228870_j_.field_78797_d = 8.0f;
    }

    public void render(T tileEntityIn, float partialTicks, @Nonnull MatrixStack matrixStackIn, @Nonnull IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntityIn.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.func_235901_b_((Property)ChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((Property)ChestBlock.field_196314_b) : ChestType.SINGLE;
        Block block = blockstate.func_177230_c();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            matrixStackIn.func_227860_a_();
            float f = ((Direction)blockstate.func_177229_b((Property)ChestBlock.field_176459_a)).func_185119_l();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper icallbackwrapper = flag ? abstractchestblock.func_225536_a_(blockstate, world, tileEntityIn.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.func_226917_a_(tileEntityIn))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLightIn);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228644_e_((ResourceLocation)this.getTexture(tileEntityIn, chesttype)));
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.func_228871_a_(matrixStackIn, ivertexbuilder, this.field_228868_h_, this.field_228870_j_, this.field_228869_i_, f1, i, combinedOverlayIn);
                } else {
                    this.func_228871_a_(matrixStackIn, ivertexbuilder, this.field_228865_e_, this.field_228867_g_, this.field_228866_f_, f1, i, combinedOverlayIn);
                }
            } else {
                this.func_228871_a_(matrixStackIn, ivertexbuilder, this.field_228862_a_, this.field_228864_d_, this.field_228863_c_, f1, i, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private void func_228871_a_(MatrixStack p_228871_1_, IVertexBuilder p_228871_2_, ModelRenderer p_228871_3_, ModelRenderer p_228871_4_, ModelRenderer p_228871_5_, float p_228871_6_, int p_228871_7_, int p_228871_8_) {
        p_228871_4_.field_78795_f = p_228871_3_.field_78795_f = -(p_228871_6_ * 1.5707964f);
        p_228871_3_.func_228308_a_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
        p_228871_4_.func_228308_a_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
        p_228871_5_.func_228308_a_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
    }

    protected abstract ResourceLocation getTexture(T var1, ChestType var2);

    protected ChestTextures getCachedTextures(MushroomWoodType woodType) {
        if (!TEXTURES.containsKey((Object)woodType)) {
            TEXTURES.put(woodType, new ChestTextures(woodType));
        }
        return TEXTURES.get((Object)woodType);
    }

    static class ChestTextures {
        public final ResourceLocation left;
        public final ResourceLocation right;
        public final ResourceLocation single;
        public final ResourceLocation trapped_left;
        public final ResourceLocation trapped_right;
        public final ResourceLocation trapped_single;

        public ChestTextures(MushroomWoodType woodType) {
            String basePath = "textures/entity/chest/" + woodType.func_176610_l();
            this.left = new ResourceLocation("extendedmushrooms", basePath + "/left.png");
            this.right = new ResourceLocation("extendedmushrooms", basePath + "/right.png");
            this.single = new ResourceLocation("extendedmushrooms", basePath + "/single.png");
            this.trapped_left = new ResourceLocation("extendedmushrooms", basePath + "/trapped_left.png");
            this.trapped_right = new ResourceLocation("extendedmushrooms", basePath + "/trapped_right.png");
            this.trapped_single = new ResourceLocation("extendedmushrooms", basePath + "/trapped_single.png");
        }
    }
}

