/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.entity.ai.goal;

import cech12.extendedmushrooms.config.Config;
import cech12.extendedmushrooms.entity.passive.MushroomSheepEntity;
import cech12.extendedmushrooms.item.MushroomType;
import java.util.EnumSet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class EatMushroomGoal
extends Goal {
    private final MobEntity eaterEntity;
    private final World entityWorld;
    int eatingTimer;

    public EatMushroomGoal(MobEntity eaterEntity) {
        this.eaterEntity = eaterEntity;
        this.entityWorld = eaterEntity.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    private boolean isEntityOnMushroom() {
        return this.entityWorld.func_180495_p(this.eaterEntity.func_233580_cy_()).func_177230_c().func_199767_j().func_206844_a((ITag)Tags.Items.MUSHROOMS);
    }

    public boolean func_75250_a() {
        return this.eaterEntity.func_70681_au().nextInt(this.eaterEntity.func_70631_g_() ? 50 : 1000) == 0 && this.isEntityOnMushroom();
    }

    public void func_75249_e() {
        this.eatingTimer = 40;
        this.entityWorld.func_72960_a((Entity)this.eaterEntity, (byte)10);
        this.eaterEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingTimer > 0;
    }

    public int getEatingTimer() {
        return this.eatingTimer;
    }

    public void func_75246_d() {
        this.eatingTimer = Math.max(0, this.eatingTimer - 1);
        if (this.eatingTimer == 4) {
            BlockPos blockPos = this.getBlockPos();
            if (this.isEntityOnMushroom()) {
                MushroomType mushroomType = MushroomType.byItemOrNull(this.entityWorld.func_180495_p(this.eaterEntity.func_233580_cy_()).func_177230_c().func_199767_j());
                if (this.entityWorld.func_82736_K().func_223586_b(GameRules.field_223599_b)) {
                    this.entityWorld.func_175655_b(blockPos, false);
                }
                this.eaterEntity.func_70615_aA();
                if (((Boolean)Config.SHEEP_ABSORB_MUSHROOM_TYPE_ENABLED.get()).booleanValue() && this.eaterEntity instanceof SheepEntity && mushroomType != null) {
                    if (this.eaterEntity instanceof MushroomSheepEntity) {
                        MushroomSheepEntity mushroomSheep = (MushroomSheepEntity)this.eaterEntity;
                        mushroomSheep.setMushroomType(mushroomType);
                        mushroomSheep.activateMushroomEffect(mushroomType);
                    } else {
                        MushroomSheepEntity.replaceSheep((SheepEntity)this.eaterEntity, mushroomType);
                    }
                }
            }
        }
    }

    private BlockPos getBlockPos() {
        return new BlockPos(this.eaterEntity.func_226277_ct_(), this.eaterEntity.func_226278_cu_(), this.eaterEntity.func_226281_cx_());
    }
}

