/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.entity.ai.goal;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EatMyceliumGoal
extends Goal {
    private static final Predicate<BlockState> IS_MYCELIUM = BlockStateMatcher.func_177638_a((Block)Blocks.field_150391_bh);
    private final MobEntity eaterEntity;
    private final World entityWorld;
    private int eatingTimer;

    public EatMyceliumGoal(MobEntity eaterEntityIn) {
        this.eaterEntity = eaterEntityIn;
        this.entityWorld = eaterEntityIn.field_70170_p;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.eaterEntity.func_70681_au().nextInt(this.eaterEntity.func_70631_g_() ? 50 : 1000) != 0) {
            return false;
        }
        BlockPos blockpos = this.eaterEntity.func_233580_cy_();
        if (IS_MYCELIUM.test(this.entityWorld.func_180495_p(blockpos))) {
            return true;
        }
        return this.entityWorld.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_150391_bh;
    }

    public void func_75249_e() {
        this.eatingTimer = 40;
        this.entityWorld.func_72960_a((Entity)this.eaterEntity, (byte)10);
        this.eaterEntity.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.eatingTimer = 0;
    }

    public boolean func_75253_b() {
        return this.eatingTimer > 0;
    }

    public int getEatingTimer() {
        return this.eatingTimer;
    }

    public void func_75246_d() {
        this.eatingTimer = Math.max(0, this.eatingTimer - 1);
        if (this.eatingTimer == 4) {
            BlockPos blockpos = this.eaterEntity.func_233580_cy_();
            if (IS_MYCELIUM.test(this.entityWorld.func_180495_p(blockpos))) {
                if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.eaterEntity)) {
                    this.entityWorld.func_175655_b(blockpos, false);
                }
                this.eaterEntity.func_70615_aA();
            } else {
                BlockPos blockpos1 = blockpos.func_177977_b();
                if (this.entityWorld.func_180495_p(blockpos1).func_177230_c() == Blocks.field_150391_bh) {
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.entityWorld, (Entity)this.eaterEntity)) {
                        this.entityWorld.func_217379_c(2001, blockpos1, Block.func_196246_j((BlockState)Blocks.field_150391_bh.func_176223_P()));
                        this.entityWorld.func_180501_a(blockpos1, Blocks.field_150346_d.func_176223_P(), 2);
                    }
                    this.eaterEntity.func_70615_aA();
                }
            }
        }
    }
}

