/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.item;

import cech12.extendedmushrooms.api.block.ExtendedMushroomsBlocks;
import cech12.extendedmushrooms.item.MushroomWoodType;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public enum MushroomType implements IStringSerializable
{
    BROWN_MUSHROOM(0, () -> Items.field_221692_bh, () -> Blocks.field_150420_aW, MushroomWoodType.MUSHROOM, DyeColor.BROWN),
    RED_MUSHROOM(1, () -> Items.field_221694_bi, () -> Blocks.field_150419_aX, MushroomWoodType.MUSHROOM, DyeColor.RED),
    GLOWSHROOM(2, () -> ExtendedMushroomsBlocks.GLOWSHROOM, () -> ExtendedMushroomsBlocks.GLOWSHROOM_CAP, MushroomWoodType.GLOWSHROOM, DyeColor.BLUE, () -> ExtendedMushroomsBlocks.GLOWSHROOM_CAP.getLightValue(ExtendedMushroomsBlocks.GLOWSHROOM_CAP.func_176223_P(), null, null)),
    POISONOUS_MUSHROOM(3, () -> ExtendedMushroomsBlocks.POISONOUS_MUSHROOM, () -> ExtendedMushroomsBlocks.POISONOUS_MUSHROOM_CAP, MushroomWoodType.POISONOUS_MUSHROOM, DyeColor.PURPLE);

    private static final MushroomType[] VALUES;
    private final int id;
    private final Supplier<IItemProvider> item;
    private final Supplier<Block> capBlock;
    private final MushroomWoodType woodType;
    private final DyeColor color;
    private final Supplier<Integer> lightValue;

    private MushroomType(int id, Supplier<IItemProvider> item, @Nonnull Supplier<Block> capBlock, MushroomWoodType woodType, DyeColor color) {
        this(id, item, capBlock, woodType, color, () -> 0);
    }

    private MushroomType(int id, Supplier<IItemProvider> item, @Nonnull Supplier<Block> capBlock, MushroomWoodType woodType, DyeColor color, Supplier<Integer> lightValue) {
        this.id = id;
        this.item = item;
        this.capBlock = capBlock;
        this.woodType = woodType;
        this.color = color;
        this.lightValue = lightValue;
    }

    public int getId() {
        return this.id;
    }

    public Item getItem() {
        return this.item.get().func_199767_j();
    }

    public Block getCapBlock() {
        return this.capBlock.get();
    }

    public MushroomWoodType getWoodType() {
        return this.woodType;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public int getLightValue() {
        return this.lightValue.get();
    }

    public ResourceLocation getSheepLootTable() {
        return new ResourceLocation("extendedmushrooms", "entities/sheep/" + this.getItem().getRegistryName().func_110623_a());
    }

    public String func_176610_l() {
        return this.getItem().getRegistryName().func_110623_a();
    }

    public static MushroomType byId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static MushroomType byItemOrNull(Item item) {
        for (MushroomType mushroomType : VALUES) {
            if (mushroomType.getItem() != item) continue;
            return mushroomType;
        }
        return null;
    }

    public static MushroomType byItem(Item item) {
        MushroomType type = MushroomType.byItemOrNull(item);
        if (type == null) {
            type = BROWN_MUSHROOM;
        }
        return type;
    }

    public static MushroomType[] getSpecialTypes() {
        return (MushroomType[])Arrays.stream(MushroomType.values()).filter(type -> type != BROWN_MUSHROOM && type != RED_MUSHROOM).toArray(MushroomType[]::new);
    }

    static {
        VALUES = (MushroomType[])Arrays.stream(MushroomType.values()).sorted(Comparator.comparingInt(MushroomType::getId)).toArray(MushroomType[]::new);
    }
}

