/*
 * Decompiled with CFR 0.152.
 */
package cech12.extendedmushrooms.world.gen.feature;

import cech12.extendedmushrooms.MushroomUtils;
import com.mojang.serialization.Codec;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public abstract class BigMushroomFeature
extends Feature<BigMushroomFeatureConfig> {
    public BigMushroomFeature(Codec<BigMushroomFeatureConfig> config) {
        super(config);
    }

    protected abstract int getCapRadius(Random var1);

    protected int getSize(Random random) {
        int i = random.nextInt(3) + 4;
        if (random.nextInt(12) == 0) {
            i *= 2;
        }
        return i;
    }

    protected boolean isInWorldBounds(IWorld world, BlockPos mushroomPos, int size) {
        int y = mushroomPos.func_177956_o();
        return y >= 1 && y + size + 1 < world.func_234938_ad_();
    }

    protected boolean hasValidGround(IWorld world, BlockPos mushroomPos) {
        return MushroomUtils.isValidMushroomPosition((IWorldReader)world, mushroomPos);
    }

    protected boolean canGrow(IWorld world, BlockPos blockPos, int size, int capRadius, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        return this.isInWorldBounds(world, blockPos, size) && this.hasValidGround(world, blockPos) && this.canPlaceTrunk(world, blockPos, size, mutableBlockPos, config) && this.canPlaceCap(world, blockPos, size, capRadius, mutableBlockPos, config);
    }

    protected abstract boolean canPlaceCap(IWorld var1, BlockPos var2, int var3, int var4, BlockPos.Mutable var5, BigMushroomFeatureConfig var6);

    protected abstract void placeCap(IWorld var1, Random var2, BlockPos var3, int var4, int var5, BlockPos.Mutable var6, BigMushroomFeatureConfig var7);

    protected boolean canPlaceTrunk(IWorld world, BlockPos blockPos, int size, BlockPos.Mutable mutableBlockPos, BigMushroomFeatureConfig config) {
        for (int i = 0; i < size; ++i) {
            mutableBlockPos.func_189533_g((Vector3i)blockPos).func_189534_c(Direction.UP, i);
            if (world.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLogs((IWorldReader)world, (BlockPos)mutableBlockPos)) continue;
            return false;
        }
        return true;
    }

    protected void placeTrunk(IWorld world, Random random, BlockPos blockPos, BigMushroomFeatureConfig config, int size, BlockPos.Mutable mutableBlockPos) {
        for (int i = 0; i < size; ++i) {
            mutableBlockPos.func_189533_g((Vector3i)blockPos).func_189534_c(Direction.UP, i);
            if (!world.func_180495_p((BlockPos)mutableBlockPos).canBeReplacedByLogs((IWorldReader)world, (BlockPos)mutableBlockPos)) continue;
            this.func_230367_a_((IWorldWriter)world, (BlockPos)mutableBlockPos, config.field_227273_b_.func_225574_a_(random, blockPos));
        }
    }

    public boolean generate(@Nonnull ISeedReader worldIn, @Nullable ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull BigMushroomFeatureConfig config) {
        BlockPos.Mutable blockpos$mutable;
        int capRadius;
        int size = this.getSize(rand);
        if (!this.canGrow((IWorld)worldIn, pos, size, capRadius = this.getCapRadius(rand), blockpos$mutable = new BlockPos.Mutable(), config)) {
            return false;
        }
        this.placeCap((IWorld)worldIn, rand, pos, size, capRadius, blockpos$mutable, config);
        this.placeTrunk((IWorld)worldIn, rand, pos, config, size, blockpos$mutable);
        return true;
    }

    protected void placeCapBlockIfPossible(IWorld world, Random random, BigMushroomFeatureConfig config, BlockPos blockPos, boolean west, boolean east, boolean north, boolean south) {
        this.placeCapBlockIfPossible(world, random, config, blockPos, west, east, north, south, true);
    }

    protected void placeCapBlockIfPossible(IWorld world, Random random, BigMushroomFeatureConfig config, BlockPos blockPos, boolean west, boolean east, boolean north, boolean south, boolean up) {
        if (world.func_180495_p(blockPos).canBeReplacedByLeaves((IWorldReader)world, blockPos)) {
            this.func_230367_a_((IWorldWriter)world, blockPos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.field_227272_a_.func_225574_a_(random, blockPos).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(west))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(east))).func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(north))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(south))).func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(up)));
        }
    }
}

