/*
 * Decompiled with CFR 0.152.
 */
package com._idrae.travelers_index.config;

import com._idrae.travelers_index.TravelersIndex;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="travelers_index", bus=Mod.EventBusSubscriber.Bus.MOD)
public class TravelersIndexConfig {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static List<String> blackListedMods;
    public static List<String> blackListedItems;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            TravelersIndexConfig.bakeConfig();
            TravelersIndex.LOGGER.info("Config set");
        }
    }

    public static void bakeConfig() {
        blackListedMods = (List)TravelersIndexConfig.COMMON.blackListedMods.get();
        blackListedItems = (List)TravelersIndexConfig.COMMON.blackListedItems.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (CommonConfig)specPair.getLeft();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<List<String>> blackListedMods;
        public final ForgeConfigSpec.ConfigValue<List<String>> blackListedItems;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("travelersIndex");
            this.blackListedMods = builder.comment("A list of blacklisted mods").define("blackListedMods", new ArrayList());
            this.blackListedItems = builder.comment("A list of blacklisted items").define("blackListedItems", new ArrayList());
            builder.pop();
        }
    }
}

