/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.end;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.end.EndLayerProviders;
import corgiaoc.byg.config.json.BYGJsonConfigHandler;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class BYGEndBiomeSource
extends BiomeProvider {
    public static final Codec<BYGEndBiomeSource> BYGENDCODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGEndBiomeSource::new)));
    private final long seed;
    private final DatapackLayer mainIslandLayer;
    private final DatapackLayer smallIslandLayer;
    private final Registry<Biome> biomeRegistry;
    private final SimplexNoiseGenerator generator;
    public static WeightedList<ResourceLocation> END_BIOMES = new WeightedList();
    public static WeightedList<ResourceLocation> VOID_BIOMES = new WeightedList();

    public BYGEndBiomeSource(Registry<Biome> registry, long seed) {
        super(BYGEndBiomeSource.handleJsonAndFillBiomeList(registry));
        this.seed = seed;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        sharedseedrandom.func_202423_a(17292);
        this.biomeRegistry = registry;
        this.mainIslandLayer = EndLayerProviders.stackLayers(this.biomeRegistry, seed);
        this.smallIslandLayer = EndLayerProviders.stackVoidLayers(this.biomeRegistry, seed);
        this.generator = new SimplexNoiseGenerator((Random)sharedseedrandom);
    }

    private static List<Biome> handleJsonAndFillBiomeList(Registry<Biome> registry) {
        BYGJsonConfigHandler.handleEndBiomeJsonConfigs(BYG.CONFIG_PATH, registry);
        return Stream.concat(BYGEndBiomeSource.END_BIOMES.field_220658_a.stream(), BYGEndBiomeSource.VOID_BIOMES.field_220658_a.stream()).map(WeightedList.Entry::func_220647_b).map(arg_0 -> registry.func_82594_a(arg_0)).collect(Collectors.toList());
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return BYGENDCODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BYGEndBiomeSource(this.biomeRegistry, seed);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int xBitOffset = x >> 2;
        int zBitOffset = z >> 2;
        if ((long)xBitOffset * (long)xBitOffset + (long)zBitOffset * (long)zBitOffset <= 4096L) {
            return (Biome)this.biomeRegistry.func_243576_d(Biomes.field_76779_k);
        }
        float sampledNoise = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.generator, (int)(xBitOffset * 2 + 1), (int)(zBitOffset * 2 + 1));
        if (sampledNoise >= -20.0f) {
            return this.mainIslandLayer.sampleEnd(this.biomeRegistry, x, z);
        }
        return this.smallIslandLayer.sampleEndVoid(this.biomeRegistry, x, z);
    }
}

