/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.end;

import corgiaoc.byg.common.world.biome.BYGEndBiome;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.end.BYGEndBiomeSource;
import corgiaoc.byg.common.world.dimension.layers.BYGEdgeLayer;
import corgiaoc.byg.common.world.dimension.layers.BYGHillsLayer;
import corgiaoc.byg.common.world.dimension.layers.WeightedMasterLayer;
import corgiaoc.byg.config.BYGWorldConfig;
import java.util.function.LongFunction;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.IExtendedNoiseRandom;
import net.minecraft.world.gen.LazyAreaLayerContext;
import net.minecraft.world.gen.area.IAreaFactory;
import net.minecraft.world.gen.area.LazyArea;
import net.minecraft.world.gen.layer.ZoomLayer;

public class EndLayerProviders {
    public static DatapackLayer stackLayers(Registry<Biome> biomeRegistry, long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory endLayer = new WeightedMasterLayer(biomeRegistry, BYGEndBiomeSource.END_BIOMES).func_202823_a(randomProvider.apply(1003958L));
        for (int endBiomeSize = 0; endBiomeSize <= (Integer)BYGWorldConfig.BIOME_SIZE_END.get(); ++endBiomeSize) {
            endLayer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(49596L + (long)endBiomeSize), endLayer);
        }
        endLayer = new BYGHillsLayer(biomeRegistry, BYGEndBiome.BIOME_TO_HILLS, 3).func_202707_a(randomProvider.apply(2848586786L), endLayer, endLayer);
        endLayer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(495949586L), endLayer);
        endLayer = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(34885L), endLayer);
        endLayer = new BYGEdgeLayer(biomeRegistry, BYGEndBiome.BIOME_TO_EDGE).func_202713_a(randomProvider.apply(2848586786L), endLayer);
        endLayer = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(395885L), endLayer);
        endLayer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28475786L), endLayer);
        return new DatapackLayer((IAreaFactory<LazyArea>)endLayer);
    }

    public static DatapackLayer stackVoidLayers(Registry<Biome> biomeRegistry, long seed) {
        LongFunction<IExtendedNoiseRandom> randomProvider = salt -> new LazyAreaLayerContext(1, seed, salt);
        IAreaFactory endLayer = new WeightedMasterLayer(biomeRegistry, BYGEndBiomeSource.VOID_BIOMES).func_202823_a(randomProvider.apply(1003958L));
        for (int endBiomeSize = 0; endBiomeSize <= (Integer)BYGWorldConfig.VOID_BIOME_SIZE.get(); ++endBiomeSize) {
            endLayer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(49596L + (long)endBiomeSize), endLayer);
        }
        endLayer = new BYGHillsLayer(biomeRegistry, BYGEndBiome.BIOME_TO_HILLS, 3).func_202707_a(randomProvider.apply(2848586786L), endLayer, endLayer);
        endLayer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(495949586L), endLayer);
        endLayer = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(34885L), endLayer);
        endLayer = new BYGEdgeLayer(biomeRegistry, BYGEndBiome.BIOME_TO_EDGE).func_202713_a(randomProvider.apply(2848586786L), endLayer);
        endLayer = ZoomLayer.FUZZY.func_202713_a(randomProvider.apply(395885L), endLayer);
        endLayer = ZoomLayer.NORMAL.func_202713_a(randomProvider.apply(28475786L), endLayer);
        return new DatapackLayer((IAreaFactory<LazyArea>)endLayer);
    }
}

