/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import corgiaoc.byg.common.world.OpenSimplexNoiseEnd;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.util.BlockHelper;
import corgiaoc.byg.util.FeatureHelper;
import corgiaoc.byg.util.ModMathHelper;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;

public class OverworldLakeFeature
extends Feature<NoFeatureConfig> {
    private static final BlockState END_STONE = Blocks.field_150348_b.func_176223_P();
    private static final OpenSimplexNoiseEnd NOISE = new OpenSimplexNoiseEnd(15152L);
    private static final BlockPos.Mutable POS = new BlockPos.Mutable();

    public OverworldLakeFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator_, Random random, BlockPos blockPos, NoFeatureConfig config) {
        BlockState state;
        double r;
        int y;
        int x;
        double radius = ModMathHelper.randRange(10.0, 20.0, random);
        double depth = radius * 0.5 * ModMathHelper.randRange(0.8, 1.2, random);
        int dist = ModMathHelper.floor(radius);
        int dist2 = ModMathHelper.floor(radius * 1.5);
        int bott = ModMathHelper.floor(depth);
        if ((blockPos = FeatureHelper.getPosOnSurfaceWG((IWorldReader)world, blockPos)).func_177956_o() < 10) {
            return false;
        }
        int waterLevel = blockPos.func_177956_o();
        BlockPos pos = FeatureHelper.getPosOnSurfaceRaycast((IWorldReader)world, blockPos.func_177964_d(dist).func_177981_b(10), 20);
        if (Math.abs(blockPos.func_177956_o() - pos.func_177956_o()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.func_177956_o(), waterLevel);
        pos = FeatureHelper.getPosOnSurfaceRaycast((IWorldReader)world, blockPos.func_177970_e(dist).func_177981_b(10), 20);
        if (Math.abs(blockPos.func_177956_o() - pos.func_177956_o()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.func_177956_o(), waterLevel);
        pos = FeatureHelper.getPosOnSurfaceRaycast((IWorldReader)world, blockPos.func_177965_g(dist).func_177981_b(10), 20);
        if (Math.abs(blockPos.func_177956_o() - pos.func_177956_o()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.func_177956_o(), waterLevel);
        pos = FeatureHelper.getPosOnSurfaceRaycast((IWorldReader)world, blockPos.func_177985_f(dist).func_177981_b(10), 20);
        if (Math.abs(blockPos.func_177956_o() - pos.func_177956_o()) > 5) {
            return false;
        }
        waterLevel = ModMathHelper.min(pos.func_177956_o(), waterLevel);
        int minX = blockPos.func_177958_n() - dist2;
        int maxX = blockPos.func_177958_n() + dist2;
        int minZ = blockPos.func_177952_p() - dist2;
        int maxZ = blockPos.func_177952_p() + dist2;
        int maskMinX = minX - 1;
        int maskMinZ = minZ - 1;
        boolean[][] mask = new boolean[maxX - minX + 3][maxZ - minZ + 3];
        for (x = minX; x <= maxX; ++x) {
            POS.func_223471_o(x);
            int mx = x - maskMinX;
            block1: for (int z = minZ; z <= maxZ; ++z) {
                POS.func_223472_q(z);
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (int y2 = waterLevel + 1; y2 <= waterLevel + 20; ++y2) {
                    POS.func_185336_p(y2);
                    FluidState fluid = world.func_204610_c((BlockPos)POS);
                    if (fluid.func_206888_e()) continue;
                    for (int i = -1; i < 2; ++i) {
                        int px = mx + i;
                        for (int j = -1; j < 2; ++j) {
                            int pz = mz + j;
                            mask[px][pz] = true;
                        }
                    }
                    continue block1;
                }
            }
        }
        for (x = minX; x <= maxX; ++x) {
            POS.func_223471_o(x);
            int x2 = x - blockPos.func_177958_n();
            x2 *= x2;
            int mx = x - maskMinX;
            block6: for (int z = minZ; z <= maxZ; ++z) {
                POS.func_223472_q(z);
                int z2 = z - blockPos.func_177952_p();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                double size = 1.0;
                for (y = blockPos.func_177956_o(); y <= blockPos.func_177956_o() + 20; ++y) {
                    POS.func_185336_p(y);
                    double add = y - blockPos.func_177956_o();
                    if (add > 5.0) {
                        size *= 0.8;
                        add = 5.0;
                    }
                    if (!((r = add * 1.8 + radius * (NOISE.eval((double)x * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75) - 1.0 / size) > 0.0)) continue block6;
                    if (!((double)(x2 + z2) <= (r *= r))) continue;
                    state = world.func_180495_p((BlockPos)POS);
                    if (state.func_235714_a_((ITag)Tags.Blocks.STONE)) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, Blocks.field_150350_a.func_176223_P());
                    }
                    if (!world.func_180495_p(pos = POS.func_177977_b()).func_235714_a_((ITag)Tags.Blocks.STONE)) continue;
                    state = world.func_226691_t_(pos).func_242440_e().func_242502_e().func_204108_a();
                    if (y > waterLevel + 1) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, state);
                        continue;
                    }
                    if (y > waterLevel) {
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, random.nextBoolean() ? state : Blocks.field_150351_n.func_176223_P());
                        continue;
                    }
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, Blocks.field_150351_n.func_176223_P());
                }
            }
        }
        double aspect = radius / depth;
        for (int x2 = blockPos.func_177958_n() - dist; x2 <= blockPos.func_177958_n() + dist; ++x2) {
            POS.func_223471_o(x2);
            int x22 = x2 - blockPos.func_177958_n();
            x22 *= x22;
            int mx = x2 - maskMinX;
            for (int z = blockPos.func_177952_p() - dist; z <= blockPos.func_177952_p() + dist; ++z) {
                POS.func_223472_q(z);
                int z2 = z - blockPos.func_177952_p();
                z2 *= z2;
                int mz = z - maskMinZ;
                if (mask[mx][mz]) continue;
                for (y = blockPos.func_177956_o() - bott; y < blockPos.func_177956_o(); ++y) {
                    POS.func_185336_p(y);
                    double y2 = (double)(y - blockPos.func_177956_o()) * aspect;
                    y2 *= y2;
                    r = radius * (NOISE.eval((double)x2 * 0.2, (double)y * 0.2, (double)z * 0.2) * 0.25 + 0.75);
                    double rb = r * 1.2;
                    r *= r;
                    rb *= rb;
                    if (y2 + (double)x22 + (double)z2 <= r) {
                        state = world.func_180495_p((BlockPos)POS);
                        if (this.canReplace(state)) {
                            state = world.func_180495_p(POS.func_177984_a());
                            state = this.canReplace(state) ? (y < waterLevel ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P()) : state;
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, state);
                        }
                        if (world.func_180495_p(pos = POS.func_177977_b()).func_177230_c().func_203417_a((ITag)Tags.Blocks.STONE)) {
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, Blocks.field_150351_n.func_176223_P());
                        }
                        pos = POS.func_177984_a();
                        while (this.canReplace(state = world.func_180495_p(pos)) && !state.func_196958_f() && state.func_204520_s().func_206888_e()) {
                            BlockHelper.setWithoutUpdate((IWorldWriter)world, pos, pos.func_177956_o() < waterLevel ? Blocks.field_150355_j : Blocks.field_150350_a);
                            pos = pos.func_177984_a();
                        }
                        continue;
                    }
                    if (y >= waterLevel || !(y2 + (double)x22 + (double)z2 <= rb)) continue;
                    if (world.func_175623_d(POS.func_177984_a())) {
                        state = world.func_226691_t_((BlockPos)POS).func_242440_e().func_242502_e().func_204108_a();
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, random.nextBoolean() ? state : Blocks.field_150351_n.func_176223_P());
                        BlockHelper.setWithoutUpdate((IWorldWriter)world, POS.func_177977_b(), END_STONE);
                        continue;
                    }
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, (BlockPos)POS, Blocks.field_150351_n.func_176223_P());
                    BlockHelper.setWithoutUpdate((IWorldWriter)world, POS.func_177977_b(), END_STONE);
                }
            }
        }
        BlockHelper.fixBlocks((IWorld)world, new BlockPos(minX - 2, waterLevel - 2, minZ - 2), new BlockPos(maxX + 2, blockPos.func_177956_o() + 20, maxZ + 2));
        return true;
    }

    private boolean canReplace(BlockState state) {
        return state.func_185904_a().func_76222_j() || state.func_235714_a_((ITag)Tags.Blocks.STONE) || state.func_235714_a_((ITag)BlockTags.field_226149_I_) || state.func_235714_a_((ITag)Tags.Blocks.ORES) || state.func_203425_a(Blocks.field_196661_l) || state.func_203425_a(Blocks.field_196660_k) || state.func_203425_a(Blocks.field_150346_d) || state.func_203425_a(Blocks.field_150351_n) || state.func_203425_a(Blocks.field_150349_c) || state.func_203425_a(Blocks.field_196658_i) || state.func_203425_a(BYGBlocks.OVERGROWN_STONE) || state.func_203425_a(BYGBlocks.WEED_GRASS) || state.func_203425_a(BYGBlocks.SHORT_GRASS) || state.func_185904_a().equals(Material.field_151585_k) || state.func_185904_a().equals(Material.field_203243_f) || state.func_185904_a().equals(Material.field_204868_h);
    }
}

