/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.config.PointyRockConfig;
import corgiaoc.byg.util.noise.simplex.chunkgen.ChunkFastSimplexStyleNoise;
import java.util.Random;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.Feature;

public class PointyRockFeature
extends Feature<PointyRockConfig> {
    protected long seed;
    protected ChunkFastSimplexStyleNoise noiseGen;
    protected ChunkFastSimplexStyleNoise noiseGen2;

    public PointyRockFeature(Codec<PointyRockConfig> config) {
        super(config);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || this.noiseGen == null) {
            this.noiseGen = new ChunkFastSimplexStyleNoise(seed + 193895856L);
            this.noiseGen2 = new ChunkFastSimplexStyleNoise(seed + 294856869L);
            this.seed = seed;
        }
    }

    public boolean place(ISeedReader world, ChunkGenerator changedBlock, Random rand, BlockPos position, PointyRockConfig config) {
        long randomLong = rand.nextLong();
        this.setSeed(world.func_72905_C() + 215465128L + randomLong);
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                mutable.func_181079_c(position.func_177958_n() + x, 0, position.func_177952_p() + z);
                double noise2 = (this.noiseGen.noise3_Classic((double)mutable.func_177958_n() * 0.04, (double)mutable.func_177956_o() * 0.04, (double)mutable.func_177952_p() * 0.04) + 1.0) * 5.0;
                double noise = Math.pow(Math.abs(this.noiseGen.sample2D((double)mutable.func_177958_n() * 0.013, (double)mutable.func_177952_p() * 0.013)) + noise2 * 0.005, 7.0);
                int maximumHeight = (int)(noise * 65.0);
                maximumHeight = (int)((double)maximumHeight * config.getHeightMultiplier());
                int terrainHeight = world.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, mutable.func_177958_n(), mutable.func_177952_p());
                mutable.func_189534_c(Direction.UP, maximumHeight);
                for (int y = maximumHeight; y >= terrainHeight; --y) {
                    world.func_180501_a((BlockPos)mutable, config.getBlockProvider().func_225574_a_(rand, (BlockPos)mutable), 2);
                    mutable.func_189536_c(Direction.DOWN);
                }
            }
        }
        return true;
    }
}

