/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.giantflowers.util;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.FeatureUtil;
import corgiaoc.byg.common.world.feature.config.GiantFlowerConfig;
import corgiaoc.byg.core.BYGBlocks;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.Tags;

public abstract class BYGAbstractGiantFlowerFeature<T extends GiantFlowerConfig>
extends Feature<T> {
    public BYGAbstractGiantFlowerFeature(Codec<T> configCodec) {
        super(configCodec);
    }

    public static boolean canStemPlaceHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, AbstractBlock.AbstractBlockState::func_196958_f) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean canStemPlaceHereWater(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_196958_f() || state.func_185904_a() == Material.field_151586_h) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherFlowerHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E);
        });
    }

    public boolean isAnotherFlowerLikeThisHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos, Block logBlock, Block leafBlock) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block == logBlock || block == leafBlock;
        });
    }

    public void placeStem(BlockState stemBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.canStemPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, stemBlockState);
        }
    }

    public void placeStemBranch(BlockState stemBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.canStemPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, stemBlockState);
        }
    }

    public void placePetal(BlockState petalBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, petalBlockState);
        }
    }

    public void placePetal2(BlockState petalBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, petalBlockState);
        }
    }

    public void placePetal3(BlockState petalBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, petalBlockState);
        }
    }

    public void placePollen(BlockState pollenBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractGiantFlowerFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, pollenBlockState);
        }
    }

    public boolean canGiantFlowerGrowHere(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E) || state.func_196958_f() || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151578_c;
        });
    }

    public static boolean isAir(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }

    public boolean isAirOrWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean isDesiredGroundwDirtTag(IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block.func_203417_a((ITag)Tags.Blocks.DIRT) || block == block1;
            }
            return block.func_203417_a((ITag)Tags.Blocks.DIRT);
        });
    }

    public boolean isDesiredGround(IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block == block1;
            }
            return false;
        });
    }

    public boolean doesFlowerHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesFlowerHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xNegativeDistance, int zNegativeDistance, int xPositiveDistance, int zPositiveDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xNegativeDistance; xOffset <= xPositiveDistance; ++xOffset) {
                    for (int zOffset = -zNegativeDistance; zOffset <= zPositiveDistance; ++zOffset) {
                        if (this.canGiantFlowerGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherFlowerNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherFlowerHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherFlowerLikeThisNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, Block logBlock, Block leafBlock, boolean isSapling) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isSapling) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (this.isAnotherFlowerLikeThisHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset), logBlock, leafBlock)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void buildStem(IWorldGenerationBaseReader reader, Block fillerBlock, Block earthBlock, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                for (int fill = 1; fill <= 15; ++fill) {
                    if (BYGAbstractGiantFlowerFeature.canStemPlaceHere(reader, (BlockPos)mutableTrunk)) {
                        if (fill <= 7) {
                            this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk, fillerBlock.func_176223_P());
                        } else {
                            this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P());
                        }
                    } else {
                        if (this.isDesiredGround(reader, (BlockPos)mutableTrunk, Blocks.field_196661_l, Blocks.field_150391_bh, BYGBlocks.PODZOL_DACITE, BYGBlocks.OVERGROWN_STONE, BYGBlocks.GLOWCELIUM)) {
                            this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P());
                        }
                        fill = 15;
                    }
                    mutableTrunk.func_189536_c(Direction.DOWN);
                }
            }
        }
    }

    public void buildBase(IWorldGenerationBaseReader reader, int earthBlockThreshold, Block fillerBlock, Block earthBlock, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                for (int fill = 1; fill <= 15; ++fill) {
                    if (BYGAbstractGiantFlowerFeature.canStemPlaceHere(reader, (BlockPos)mutableTrunk)) {
                        if (fill <= earthBlockThreshold) {
                            this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk, fillerBlock.func_176223_P());
                        } else {
                            this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P());
                        }
                    } else if (BYGAbstractGiantFlowerFeature.canStemPlaceHere(reader, (BlockPos)mutableTrunk)) {
                        this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk, fillerBlock.func_176223_P());
                    } else {
                        if (this.isDesiredGround(reader, (BlockPos)mutableTrunk, Blocks.field_196661_l, Blocks.field_150391_bh, BYGBlocks.PODZOL_DACITE, BYGBlocks.OVERGROWN_STONE, BYGBlocks.GLOWCELIUM)) {
                            this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk, earthBlock.func_176223_P());
                        }
                        fill = 15;
                    }
                    mutableTrunk.func_189536_c(Direction.DOWN);
                }
            }
        }
    }

    public void setSoil(IWorldGenerationBaseReader reader, Block soil, BlockPos ... trunkPositions) {
        if (trunkPositions.length > 0) {
            BlockPos.Mutable mutableTrunk = new BlockPos.Mutable();
            for (BlockPos trunkPos : trunkPositions) {
                mutableTrunk.func_189533_g((Vector3i)trunkPos);
                if (!this.isDesiredGround(reader, (BlockPos)mutableTrunk, Blocks.field_196661_l, Blocks.field_150391_bh, BYGBlocks.PODZOL_DACITE, BYGBlocks.OVERGROWN_STONE, BYGBlocks.GLOWCELIUM)) continue;
                this.setFinalBlockState((IWorldWriter)reader, (BlockPos)mutableTrunk.func_189536_c(Direction.DOWN), soil.func_176223_P());
            }
        }
    }

    public final void setFinalBlockState(IWorldWriter worldIn, BlockPos pos, BlockState blockState) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
    }

    public void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        worldWriter.func_180501_a(blockPos, blockState, 2);
    }

    protected void func_230367_a_(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, T config) {
        return this.placeFlower(worldIn, rand, pos, ((GiantFlowerConfig)config).isPlacementForced(), config);
    }

    protected abstract boolean placeFlower(ISeedReader var1, Random var2, BlockPos var3, boolean var4, T var5);
}

