/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.endbiomedata;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import corgiaoc.byg.BYG;
import corgiaoc.byg.config.json.endbiomedata.EndBiomeData;
import corgiaoc.byg.config.json.endbiomedata.EndBiomeDataListHolder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class EndBiomeDataListHolderSerializer
implements JsonSerializer<EndBiomeDataListHolder>,
JsonDeserializer<EndBiomeDataListHolder> {
    private final Registry<Biome> biomeRegistry;
    public static List<BiomeDictionary.Type> defaultTypesList = new ArrayList<BiomeDictionary.Type>();
    public static List<BiomeDictionary.Type> stopSpamLoggerSpam;

    public EndBiomeDataListHolderSerializer(Registry<Biome> biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
    }

    public JsonElement serialize(EndBiomeDataListHolder Src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject biomes = new JsonObject();
        JsonObject endBiomeObject = new JsonObject();
        JsonObject voidBiomeObject = new JsonObject();
        for (EndBiomeData endBiomeData : Src.getEndBiomeData()) {
            JsonArray hillListArray = new JsonArray();
            JsonObject endBiome = new JsonObject();
            if (endBiomeData.getBiomeWeightedList() != null) {
                for (WeightedList.Entry biomeEntry : endBiomeData.getBiomeWeightedList().field_220658_a) {
                    JsonObject object2 = new JsonObject();
                    ResourceLocation biomeEntryKey = (ResourceLocation)biomeEntry.func_220647_b();
                    if (biomeEntryKey != null) {
                        object2.addProperty("name", biomeEntryKey.toString());
                        object2.addProperty("weight", (Number)biomeEntry.field_220652_c);
                        hillListArray.add((JsonElement)object2);
                        continue;
                    }
                    BYG.LOGGER.error("One or more \"hills\" \"name\" value was null/incorrect.");
                }
            }
            StringBuilder dictionaryString = new StringBuilder();
            for (WeightedList.Entry type : endBiomeData.getDictionaryTypes()) {
                if (!dictionaryString.toString().isEmpty()) {
                    dictionaryString.append(",");
                }
                dictionaryString.append(type.toString());
            }
            endBiome.addProperty("dictionary", dictionaryString.toString().toUpperCase());
            endBiome.addProperty("weight", (Number)endBiomeData.getBiomeWeight());
            ResourceLocation edgeKey = endBiomeData.getEdgeBiome();
            if (edgeKey != null) {
                endBiome.addProperty("edge", edgeKey.toString());
            } else {
                endBiome.addProperty("edge", "");
            }
            endBiome.add("hills", (JsonElement)hillListArray);
            ResourceLocation location = endBiomeData.getBiome();
            if (location != null) {
                if (dictionaryString.toString().contains("VOID")) {
                    voidBiomeObject.add(location.toString(), (JsonElement)endBiome);
                    continue;
                }
                endBiomeObject.add(location.toString(), (JsonElement)endBiome);
                continue;
            }
            BYG.LOGGER.error("The Biome key was null! This should NEVER happen.");
        }
        biomes.add("biomes", (JsonElement)endBiomeObject);
        biomes.add("void-biomes", (JsonElement)voidBiomeObject);
        return biomes;
    }

    public EndBiomeDataListHolder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        BYG.LOGGER.info("Reading json");
        JsonObject jsonObject = json.getAsJsonObject();
        ArrayList<EndBiomeData> endBiomeData = new ArrayList<EndBiomeData>();
        ArrayList<EndBiomeData> voidBiomeData = new ArrayList<EndBiomeData>();
        this.extractElements(endBiomeData, jsonObject.get("biomes").getAsJsonObject().entrySet());
        this.extractElements(voidBiomeData, jsonObject.get("void-biomes").getAsJsonObject().entrySet());
        return new EndBiomeDataListHolder(endBiomeData, voidBiomeData);
    }

    private void extractElements(List<EndBiomeData> endBiomeData, Set<Map.Entry<String, JsonElement>> entrySet) {
        for (Map.Entry<String, JsonElement> elementEntry : entrySet) {
            WeightedList weightedList = new WeightedList();
            String biomeName = elementEntry.getKey();
            JsonElement element = elementEntry.getValue();
            JsonObject elementObject = element.getAsJsonObject();
            String edge = elementObject.get("edge").getAsString();
            int weight = elementObject.get("weight").getAsInt();
            JsonArray hillLayerList = elementObject.get("hills").getAsJsonArray();
            String dictionary = elementObject.get("dictionary").getAsString();
            List<BiomeDictionary.Type> types = Arrays.stream(dictionary.trim().replace(" ", "").toUpperCase().split(",")).map(this::warnIfTagIsNotDefault).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toList());
            BiomeDictionary.Type[] typesArray = new BiomeDictionary.Type[types.size()];
            typesArray = types.toArray(typesArray);
            if (types.size() == 0) {
                types.add(BiomeDictionary.Type.END);
                BYG.LOGGER.warn("No dictionary entries were read...defaulting to: \"END\"");
            }
            for (JsonElement hillElement : hillLayerList) {
                ResourceLocation hillResourceLocation;
                JsonObject hillObject = hillElement.getAsJsonObject();
                String hillBiomeName = hillObject.get("name").getAsString();
                Integer hillWeight = hillObject.get("weight").getAsInt();
                if (hillBiomeName == null || hillWeight == null || (hillResourceLocation = new ResourceLocation(hillBiomeName)) == null) continue;
                if (this.biomeRegistry.func_148742_b().contains(hillResourceLocation)) {
                    weightedList.func_226313_a_((Object)hillResourceLocation, hillWeight.intValue());
                    continue;
                }
                BYG.LOGGER.error("Could not find: \"" + hillResourceLocation.toString() + "\" in the biome registry!\nEntry will not be added. Skipping entry...");
            }
            ResourceLocation biomeKey = new ResourceLocation(biomeName);
            if (this.biomeRegistry.func_148742_b().contains(biomeKey)) {
                endBiomeData.add(new EndBiomeData(biomeKey, weight, typesArray, (WeightedList<ResourceLocation>)weightedList, new ResourceLocation(edge)));
                continue;
            }
            BYG.LOGGER.error("The biome key: \"" + biomeName + "\" was not found in the registry, skipping entry...");
        }
    }

    public String warnIfTagIsNotDefault(String string) {
        BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        if (!defaultTypesList.contains(type) && !stopSpamLoggerSpam.contains(type)) {
            BYG.LOGGER.warn(type.toString() + " is not a default dictionary value.\nIgnore this msg if using modded biome dictionary values.");
            stopSpamLoggerSpam.add(type);
        }
        return string;
    }

    static {
        defaultTypesList.add(BiomeDictionary.Type.HOT);
        defaultTypesList.add(BiomeDictionary.Type.COLD);
        defaultTypesList.add(BiomeDictionary.Type.SPARSE);
        defaultTypesList.add(BiomeDictionary.Type.DENSE);
        defaultTypesList.add(BiomeDictionary.Type.WET);
        defaultTypesList.add(BiomeDictionary.Type.DRY);
        defaultTypesList.add(BiomeDictionary.Type.SAVANNA);
        defaultTypesList.add(BiomeDictionary.Type.CONIFEROUS);
        defaultTypesList.add(BiomeDictionary.Type.JUNGLE);
        defaultTypesList.add(BiomeDictionary.Type.SPOOKY);
        defaultTypesList.add(BiomeDictionary.Type.DEAD);
        defaultTypesList.add(BiomeDictionary.Type.LUSH);
        defaultTypesList.add(BiomeDictionary.Type.MUSHROOM);
        defaultTypesList.add(BiomeDictionary.Type.MAGICAL);
        defaultTypesList.add(BiomeDictionary.Type.RARE);
        defaultTypesList.add(BiomeDictionary.Type.PLATEAU);
        defaultTypesList.add(BiomeDictionary.Type.MODIFIED);
        defaultTypesList.add(BiomeDictionary.Type.OCEAN);
        defaultTypesList.add(BiomeDictionary.Type.RIVER);
        defaultTypesList.add(BiomeDictionary.Type.WATER);
        defaultTypesList.add(BiomeDictionary.Type.MESA);
        defaultTypesList.add(BiomeDictionary.Type.FOREST);
        defaultTypesList.add(BiomeDictionary.Type.PLAINS);
        defaultTypesList.add(BiomeDictionary.Type.MOUNTAIN);
        defaultTypesList.add(BiomeDictionary.Type.HILLS);
        defaultTypesList.add(BiomeDictionary.Type.SWAMP);
        defaultTypesList.add(BiomeDictionary.Type.SANDY);
        defaultTypesList.add(BiomeDictionary.Type.SNOWY);
        defaultTypesList.add(BiomeDictionary.Type.WASTELAND);
        defaultTypesList.add(BiomeDictionary.Type.VOID);
        defaultTypesList.add(BiomeDictionary.Type.OVERWORLD);
        defaultTypesList.add(BiomeDictionary.Type.BEACH);
        defaultTypesList.add(BiomeDictionary.Type.NETHER);
        defaultTypesList.add(BiomeDictionary.Type.END);
        stopSpamLoggerSpam = new ArrayList<BiomeDictionary.Type>();
    }
}

