/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.config.json.subbiomedata;

import corgiaoc.byg.common.world.biome.BYGBiome;
import corgiaoc.byg.common.world.biome.BYGSubBiome;
import corgiaoc.byg.config.json.subbiomedata.SubBiomeData;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraftforge.common.BiomeDictionary;

public class SubBiomeDataListHolder {
    List<SubBiomeData> subBiomeData;

    public SubBiomeDataListHolder(List<SubBiomeData> subBiomeData) {
        this.subBiomeData = subBiomeData;
    }

    public List<SubBiomeData> getSubBiomeData() {
        return this.subBiomeData;
    }

    public static void createDefaults() {
        for (BYGSubBiome bygSubBiome : BYGSubBiome.BYG_SUB_BIOMES) {
            List<BiomeDictionary.Type> typeList = Arrays.asList(bygSubBiome.getBiomeDictionary());
            typeList.sort(Comparator.comparing(Object::toString));
            BYGSubBiome.subBiomeData.add(new SubBiomeData(bygSubBiome.getBiome(), typeList.toArray(new BiomeDictionary.Type[0]), bygSubBiome.getEdge(), bygSubBiome.getBeach(), bygSubBiome.getRiver()));
        }
        BYGSubBiome.subBiomeData.sort(Comparator.comparing(data -> WorldGenRegistries.field_243657_i.func_177774_c((Object)data.getBiome()).toString()));
    }

    public static void fillBiomeLists() {
        for (SubBiomeData biomeData : BYGSubBiome.subBiomeData) {
            if (biomeData.getBeachBiome() != null) {
                BYGBiome.BIOME_TO_BEACH_LIST.put(WorldGenRegistries.field_243657_i.func_148757_b((Object)biomeData.getBiome()), (Object)biomeData.getBeachBiome());
            }
            if (biomeData.getEdgeBiome() != null) {
                BYGBiome.BIOME_TO_EDGE_LIST.put(WorldGenRegistries.field_243657_i.func_148757_b((Object)biomeData.getBiome()), (Object)biomeData.getEdgeBiome());
            }
            if (biomeData.getRiverBiome() == null) continue;
            BYGBiome.BIOME_TO_RIVER_LIST.put(WorldGenRegistries.field_243657_i.func_148757_b((Object)biomeData.getBiome()), (Object)biomeData.getRiverBiome());
        }
        BYGBiome.BIOME_TO_EDGE_LIST.remove(-1);
        BYGBiome.BIOME_TO_BEACH_LIST.remove(-1);
        BYGBiome.BIOME_TO_RIVER_LIST.remove(-1);
    }
}

