/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.protect;

import com.earth2me.essentials.metrics.MetricsWrapper;
import com.earth2me.essentials.protect.EmergencyListener;
import com.earth2me.essentials.protect.EssentialsConnect;
import com.earth2me.essentials.protect.EssentialsProtectBlockListener;
import com.earth2me.essentials.protect.EssentialsProtectBlockListener_1_16_R1;
import com.earth2me.essentials.protect.EssentialsProtectEntityListener;
import com.earth2me.essentials.protect.EssentialsProtectEntityListener_1_13_2_R1;
import com.earth2me.essentials.protect.EssentialsProtectEntityListener_1_14_R1;
import com.earth2me.essentials.protect.EssentialsProtectWeatherListener;
import com.earth2me.essentials.protect.IProtect;
import com.earth2me.essentials.protect.ProtectConfig;
import com.earth2me.essentials.utils.VersionUtil;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EssentialsProtect
extends JavaPlugin
implements IProtect {
    private final Map<ProtectConfig, Boolean> settingsBoolean = new EnumMap<ProtectConfig, Boolean>(ProtectConfig.class);
    private final Map<ProtectConfig, String> settingsString = new EnumMap<ProtectConfig, String>(ProtectConfig.class);
    private final Map<ProtectConfig, List<Material>> settingsList = new EnumMap<ProtectConfig, List<Material>>(ProtectConfig.class);
    private final EmergencyListener emListener = new EmergencyListener(this);
    private EssentialsConnect ess = null;
    private transient MetricsWrapper metrics = null;

    public void onEnable() {
        PluginManager pm = this.getServer().getPluginManager();
        Plugin essPlugin = pm.getPlugin("Essentials");
        if (essPlugin == null || !essPlugin.isEnabled()) {
            this.enableEmergencyMode(pm);
            return;
        }
        this.initialize(pm, essPlugin);
        if (this.metrics == null) {
            this.metrics = new MetricsWrapper((Plugin)this, 3816, false);
        }
    }

    private void initialize(PluginManager pm, Plugin essPlugin) {
        this.getLogger().log(Level.INFO, "Continuing to enable Protect.");
        this.ess = new EssentialsConnect(essPlugin, this);
        EssentialsProtectBlockListener blockListener = new EssentialsProtectBlockListener(this);
        pm.registerEvents((Listener)blockListener, (Plugin)this);
        EssentialsProtectEntityListener entityListener = new EssentialsProtectEntityListener(this);
        pm.registerEvents((Listener)entityListener, (Plugin)this);
        if (VersionUtil.getServerBukkitVersion().isHigherThan(VersionUtil.v1_13_2_R01)) {
            EssentialsProtectEntityListener_1_13_2_R1 entityListener_1_13_2_r1 = new EssentialsProtectEntityListener_1_13_2_R1(this);
            pm.registerEvents((Listener)entityListener_1_13_2_r1, (Plugin)this);
        }
        if (VersionUtil.getServerBukkitVersion().isHigherThan(VersionUtil.v1_14_R01)) {
            EssentialsProtectEntityListener_1_14_R1 entityListener_1_14_r1 = new EssentialsProtectEntityListener_1_14_R1(this);
            pm.registerEvents((Listener)entityListener_1_14_r1, (Plugin)this);
        }
        if (VersionUtil.getServerBukkitVersion().isHigherThanOrEqualTo(VersionUtil.v1_16_1_R01)) {
            EssentialsProtectBlockListener_1_16_R1 blockListener_1_16_r1 = new EssentialsProtectBlockListener_1_16_R1(this);
            pm.registerEvents((Listener)blockListener_1_16_r1, (Plugin)this);
        }
        EssentialsProtectWeatherListener weatherListener = new EssentialsProtectWeatherListener(this);
        pm.registerEvents((Listener)weatherListener, (Plugin)this);
    }

    private void enableEmergencyMode(PluginManager pm) {
        pm.registerEvents((Listener)this.emListener, (Plugin)this);
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.sendMessage("Essentials Protect is in emergency mode. Check your log for errors.");
        }
        this.getLogger().log(Level.SEVERE, "Essentials not installed or failed to load. Essentials Protect is in emergency mode now.");
    }

    void disableEmergencyMode() {
        PluginManager pm = this.getServer().getPluginManager();
        Plugin essPlugin = pm.getPlugin("Essentials");
        if (essPlugin == null || !essPlugin.isEnabled()) {
            this.getLogger().log(Level.SEVERE, "Tried to disable emergency mode, but Essentials still isn't enabled!");
            return;
        }
        HandlerList.unregisterAll((Listener)this.emListener);
        for (Player player : this.getServer().getOnlinePlayers()) {
            player.sendMessage("Essentials Protect is no longer in emergency mode.");
        }
        this.getLogger().log(Level.SEVERE, "Essentials was loaded late! Essentials Protect is no longer in emergency mode.");
        this.initialize(pm, essPlugin);
    }

    @Override
    public EssentialsConnect getEssentialsConnect() {
        return this.ess;
    }

    @Override
    public Map<ProtectConfig, Boolean> getSettingsBoolean() {
        return this.settingsBoolean;
    }

    @Override
    public Map<ProtectConfig, String> getSettingsString() {
        return this.settingsString;
    }

    @Override
    public Map<ProtectConfig, List<Material>> getSettingsList() {
        return this.settingsList;
    }

    @Override
    public boolean getSettingBool(ProtectConfig protectConfig) {
        Boolean bool = this.settingsBoolean.get((Object)protectConfig);
        return bool == null ? protectConfig.getDefaultValueBoolean() : bool.booleanValue();
    }

    @Override
    public String getSettingString(ProtectConfig protectConfig) {
        String str = this.settingsString.get((Object)protectConfig);
        return str == null ? protectConfig.getDefaultValueString() : str;
    }
}

