/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.protect;

import com.earth2me.essentials.User;
import com.earth2me.essentials.protect.IProtect;
import com.earth2me.essentials.protect.ProtectConfig;
import java.util.Locale;
import net.ess3.api.IEssentials;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreakDoorEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

public class EssentialsProtectEntityListener
implements Listener {
    private final IProtect prot;
    private final IEssentials ess;

    EssentialsProtectEntityListener(IProtect prot) {
        this.prot = prot;
        this.ess = prot.getEssentialsConnect().getEssentials();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity target = event.getEntity();
        if (target instanceof Villager && this.prot.getSettingBool(ProtectConfig.prevent_villager_death)) {
            event.setCancelled(true);
            return;
        }
        User user = null;
        if (target instanceof Player) {
            user = this.ess.getUser((Player)target);
        }
        EntityDamageEvent.DamageCause cause = event.getCause();
        if (event instanceof EntityDamageByBlockEvent) {
            if (!(!this.prot.getSettingBool(ProtectConfig.disable_contactdmg) || cause != EntityDamageEvent.DamageCause.CONTACT || target instanceof Player && this.shouldBeDamaged(user, "contact"))) {
                event.setCancelled(true);
                return;
            }
            if (!(!this.prot.getSettingBool(ProtectConfig.disable_lavadmg) || cause != EntityDamageEvent.DamageCause.LAVA || target instanceof Player && this.shouldBeDamaged(user, "lava"))) {
                event.setCancelled(true);
                return;
            }
            if (!(!this.prot.getSettingBool(ProtectConfig.prevent_tnt_explosion) || cause != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION || target instanceof Player && this.shouldBeDamaged(user, "tnt"))) {
                event.setCancelled(true);
                return;
            }
        }
        if (event instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent edEvent = (EntityDamageByEntityEvent)event;
            Entity eAttack = edEvent.getDamager();
            User attacker = null;
            if (eAttack instanceof Player) {
                attacker = this.ess.getUser((Player)eAttack);
            }
            if (eAttack instanceof Creeper && this.prot.getSettingBool(ProtectConfig.prevent_creeper_playerdmg) && (!(target instanceof Player) || !this.shouldBeDamaged(user, "creeper"))) {
                event.setCancelled(true);
                return;
            }
            if (!(!(event.getEntity() instanceof Fireball) && !(event.getEntity() instanceof SmallFireball) || !this.prot.getSettingBool(ProtectConfig.prevent_fireball_playerdmg) || target instanceof Player && this.shouldBeDamaged(user, "fireball"))) {
                event.setCancelled(true);
                return;
            }
            if (event.getEntity() instanceof WitherSkull && this.prot.getSettingBool(ProtectConfig.prevent_witherskull_playerdmg) && (!(target instanceof Player) || !this.shouldBeDamaged(user, "witherskull"))) {
                event.setCancelled(true);
                return;
            }
            if (eAttack instanceof TNTPrimed && this.prot.getSettingBool(ProtectConfig.prevent_tnt_playerdmg) && (!(target instanceof Player) || !this.shouldBeDamaged(user, "tnt"))) {
                event.setCancelled(true);
                return;
            }
            if (eAttack instanceof ExplosiveMinecart && this.prot.getSettingBool(ProtectConfig.prevent_tntminecart_playerdmg) && (!(target instanceof Player) || !this.shouldBeDamaged(user, "tnt-minecart"))) {
                event.setCancelled(true);
                return;
            }
            if (target instanceof Player && eAttack instanceof Player && this.prot.getSettingBool(ProtectConfig.disable_pvp) && !user.getName().equalsIgnoreCase(attacker.getName()) && (!user.isAuthorized("essentials.protect.pvp") || !attacker.isAuthorized("essentials.protect.pvp"))) {
                event.setCancelled(true);
                return;
            }
            if (edEvent.getDamager() instanceof Projectile && target instanceof Player && (this.prot.getSettingBool(ProtectConfig.disable_projectiles) && !this.shouldBeDamaged(user, "projectiles") || ((Projectile)edEvent.getDamager()).getShooter() instanceof Player && this.prot.getSettingBool(ProtectConfig.disable_pvp) && (!user.isAuthorized("essentials.protect.pvp") || !this.ess.getUser((Player)((Projectile)edEvent.getDamager()).getShooter()).isAuthorized("essentials.protect.pvp")))) {
                event.setCancelled(true);
                return;
            }
        }
        if (target instanceof Player) {
            if (cause == EntityDamageEvent.DamageCause.FALL && this.prot.getSettingBool(ProtectConfig.disable_fall) && !this.shouldBeDamaged(user, "fall")) {
                event.setCancelled(true);
                return;
            }
            if (cause == EntityDamageEvent.DamageCause.SUFFOCATION && this.prot.getSettingBool(ProtectConfig.disable_suffocate) && !this.shouldBeDamaged(user, "suffocation")) {
                event.setCancelled(true);
                return;
            }
            if ((cause == EntityDamageEvent.DamageCause.FIRE || cause == EntityDamageEvent.DamageCause.FIRE_TICK) && this.prot.getSettingBool(ProtectConfig.disable_firedmg) && !this.shouldBeDamaged(user, "fire")) {
                event.setCancelled(true);
                return;
            }
            if (cause == EntityDamageEvent.DamageCause.DROWNING && this.prot.getSettingBool(ProtectConfig.disable_drown) && !this.shouldBeDamaged(user, "drowning")) {
                event.setCancelled(true);
                return;
            }
            if (cause == EntityDamageEvent.DamageCause.LIGHTNING && this.prot.getSettingBool(ProtectConfig.disable_lightning) && !this.shouldBeDamaged(user, "lightning")) {
                event.setCancelled(true);
                return;
            }
            if (cause == EntityDamageEvent.DamageCause.WITHER && this.prot.getSettingBool(ProtectConfig.disable_wither) && !this.shouldBeDamaged(user, "wither")) {
                event.setCancelled(true);
            }
        }
    }

    private boolean shouldBeDamaged(User user, String type) {
        return user.isAuthorized("essentials.protect.damage.".concat(type)) && !user.isAuthorized("essentials.protect.damage.disable");
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getEntity() == null) {
            return;
        }
        Entity entity = event.getEntity();
        int maxHeight = this.ess.getSettings().getProtectCreeperMaxHeight();
        if (entity instanceof EnderDragon && this.prot.getSettingBool(ProtectConfig.prevent_enderdragon_blockdmg)) {
            event.setCancelled(true);
            if (this.prot.getSettingBool(ProtectConfig.enderdragon_fakeexplosions)) {
                event.getLocation().getWorld().createExplosion(event.getLocation(), 0.0f);
            }
            return;
        }
        if (entity instanceof Wither && this.prot.getSettingBool(ProtectConfig.prevent_wither_spawnexplosion)) {
            event.setCancelled(true);
        } else if (entity instanceof Creeper && (this.prot.getSettingBool(ProtectConfig.prevent_creeper_explosion) || this.prot.getSettingBool(ProtectConfig.prevent_creeper_blockdmg) || maxHeight >= 0 && event.getLocation().getBlockY() > maxHeight)) {
            event.setCancelled(true);
            event.getLocation().getWorld().createExplosion(event.getLocation(), 0.0f);
        } else if (entity instanceof TNTPrimed && this.prot.getSettingBool(ProtectConfig.prevent_tnt_explosion)) {
            event.setCancelled(true);
        } else if (entity instanceof Fireball && this.prot.getSettingBool(ProtectConfig.prevent_fireball_explosion)) {
            event.setCancelled(true);
        } else if (entity instanceof WitherSkull && this.prot.getSettingBool(ProtectConfig.prevent_witherskull_explosion)) {
            event.setCancelled(true);
        } else if (entity instanceof ExplosiveMinecart && this.prot.getSettingBool(ProtectConfig.prevent_tntminecart_explosion)) {
            event.setCancelled(true);
        } else if (entity instanceof EnderCrystal && this.prot.getSettingBool(ProtectConfig.prevent_ender_crystal_explosion)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getEntity() instanceof Player) {
            return;
        }
        EntityType creature = event.getEntityType();
        if (creature == null) {
            return;
        }
        String creatureName = creature.toString().toLowerCase(Locale.ENGLISH);
        if (creatureName.isEmpty()) {
            return;
        }
        if (this.ess.getSettings().getProtectPreventSpawn(creatureName)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        if (!(event.getTarget() instanceof Player)) {
            return;
        }
        User user = this.ess.getUser((Player)event.getTarget());
        if ((event.getReason() == EntityTargetEvent.TargetReason.CLOSEST_PLAYER || event.getReason() == EntityTargetEvent.TargetReason.TARGET_ATTACKED_ENTITY || event.getReason() == EntityTargetEvent.TargetReason.TARGET_ATTACKED_NEARBY_ENTITY || event.getReason() == EntityTargetEvent.TargetReason.RANDOM_TARGET || event.getReason() == EntityTargetEvent.TargetReason.DEFEND_VILLAGE || event.getReason() == EntityTargetEvent.TargetReason.TARGET_ATTACKED_OWNER || event.getReason() == EntityTargetEvent.TargetReason.OWNER_ATTACKED_TARGET) && this.prot.getSettingBool(ProtectConfig.prevent_entitytarget) && !user.isAuthorized("essentials.protect.entitytarget.bypass")) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        if ((event.getEntity() instanceof Fireball || event.getEntity() instanceof SmallFireball) && this.prot.getSettingBool(ProtectConfig.prevent_fireball_fire)) {
            event.setFire(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (event.getEntityType() == EntityType.ENDERMAN && this.prot.getSettingBool(ProtectConfig.prevent_enderman_pickup)) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntityType() == EntityType.WITHER && this.prot.getSettingBool(ProtectConfig.prevent_wither_blockreplace)) {
            event.setCancelled(true);
        }
        if (event.getEntityType() == EntityType.SHEEP && this.prot.getSettingBool(ProtectConfig.prevent_sheep_eat_grass)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onDoorBreak(EntityBreakDoorEvent event) {
        if (event.getEntityType() == EntityType.ZOMBIE && this.prot.getSettingBool(ProtectConfig.prevent_zombie_door_break)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPaintingBreak(HangingBreakByEntityEvent event) {
        if (event.getCause() == HangingBreakEvent.RemoveCause.ENTITY && (event.getRemover() instanceof Creeper && this.prot.getSettingBool(ProtectConfig.prevent_creeper_explosion) || (event.getRemover() instanceof Fireball || event.getRemover() instanceof SmallFireball) && this.prot.getSettingBool(ProtectConfig.prevent_fireball_explosion) || event.getRemover() instanceof TNTPrimed && this.prot.getSettingBool(ProtectConfig.prevent_tnt_explosion) || event.getRemover() instanceof WitherSkull && this.prot.getSettingBool(ProtectConfig.prevent_witherskull_explosion))) {
            event.setCancelled(true);
        }
    }
}

