/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.loader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import me.lucko.luckperms.common.loader.LoaderBootstrap;
import me.lucko.luckperms.common.loader.LoadingException;

public class JarInJarClassLoader
extends URLClassLoader {
    public JarInJarClassLoader(ClassLoader loaderClassLoader, String jarResourcePath) throws LoadingException {
        super(new URL[]{JarInJarClassLoader.extractJar(loaderClassLoader, jarResourcePath)}, loaderClassLoader);
    }

    public void addJarToClasspath(URL url) {
        this.addURL(url);
    }

    public <T> LoaderBootstrap instantiatePlugin(String bootstrapClass, Class<T> loaderPluginType, T loaderPlugin) throws LoadingException {
        Constructor<LoaderBootstrap> constructor;
        Class<LoaderBootstrap> plugin;
        try {
            plugin = this.loadClass(bootstrapClass).asSubclass(LoaderBootstrap.class);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to load bootstrap class", e);
        }
        try {
            constructor = plugin.getConstructor(loaderPluginType);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to get bootstrap constructor", e);
        }
        try {
            return constructor.newInstance(loaderPlugin);
        }
        catch (ReflectiveOperationException e) {
            throw new LoadingException("Unable to create bootstrap plugin instance", e);
        }
    }

    private static URL extractJar(ClassLoader loaderClassLoader, String jarResourcePath) throws LoadingException {
        Path path;
        URL jarInJar = loaderClassLoader.getResource(jarResourcePath);
        if (jarInJar == null) {
            throw new LoadingException("Could not locate jar-in-jar");
        }
        try {
            path = Files.createTempFile("luckperms-jarinjar", ".jar.tmp", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new LoadingException("Unable to create a temporary file", e);
        }
        path.toFile().deleteOnExit();
        try (InputStream in = jarInJar.openStream();){
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new LoadingException("Unable to copy jar-in-jar to temporary path", e);
        }
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new LoadingException("Unable to get URL from path", e);
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

