/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.context;

import java.util.Objects;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.context.Context;
import net.luckperms.api.context.ContextSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface ImmutableContextSet
extends ContextSet {
    public static @NonNull Builder builder() {
        return LuckPermsProvider.get().getContextManager().getContextSetFactory().immutableBuilder();
    }

    public static @NonNull ImmutableContextSet empty() {
        return LuckPermsProvider.get().getContextManager().getContextSetFactory().immutableEmpty();
    }

    public static @NonNull ImmutableContextSet of(@NonNull String key, @NonNull String value) {
        return LuckPermsProvider.get().getContextManager().getContextSetFactory().immutableOf(key, value);
    }

    @Override
    @Deprecated
    public @NonNull ImmutableContextSet immutableCopy();

    public static interface Builder {
        public @NonNull Builder add(@NonNull String var1, @NonNull String var2);

        default public @NonNull Builder add(@NonNull Context entry) {
            Objects.requireNonNull(entry, "entry");
            this.add(entry.getKey(), entry.getValue());
            return this;
        }

        default public @NonNull Builder addAll(@NonNull Iterable<Context> iterable) {
            for (Context e : Objects.requireNonNull(iterable, "iterable")) {
                this.add(e);
            }
            return this;
        }

        public @NonNull Builder addAll(@NonNull ContextSet var1);

        public @NonNull ImmutableContextSet build();
    }
}

