/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedSet;
import java.util.stream.Collectors;
import net.luckperms.api.cacheddata.CachedDataManager;
import net.luckperms.api.model.data.DataType;
import net.luckperms.api.model.data.NodeMap;
import net.luckperms.api.model.group.Group;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.NodeType;
import net.luckperms.api.query.QueryOptions;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.Unmodifiable;

public interface PermissionHolder {
    public @NonNull Identifier getIdentifier();

    public @NonNull String getFriendlyName();

    public @NonNull QueryOptions getQueryOptions();

    public @NonNull CachedDataManager getCachedData();

    public @NonNull NodeMap getData(@NonNull DataType var1);

    public @NonNull NodeMap data();

    public @NonNull NodeMap transientData();

    default public @NonNull @Unmodifiable Collection<Node> getNodes() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(this.data().toCollection());
        nodes.addAll(this.transientData().toCollection());
        return nodes;
    }

    default public <T extends Node> @NonNull @Unmodifiable Collection<T> getNodes(@NonNull NodeType<T> type) {
        return this.getNodes().stream().filter(type::matches).map(type::cast).collect(Collectors.toList());
    }

    public @NonNull @Unmodifiable SortedSet<Node> getDistinctNodes();

    public @NonNull @Unmodifiable Collection<Node> resolveInheritedNodes(@NonNull QueryOptions var1);

    default public <T extends Node> @NonNull @Unmodifiable Collection<T> resolveInheritedNodes(@NonNull NodeType<T> type, @NonNull QueryOptions queryOptions) {
        return this.resolveInheritedNodes(queryOptions).stream().filter(type::matches).map(type::cast).collect(Collectors.toList());
    }

    public @NonNull @Unmodifiable SortedSet<Node> resolveDistinctInheritedNodes(@NonNull QueryOptions var1);

    public @NonNull @Unmodifiable Collection<Group> getInheritedGroups(@NonNull QueryOptions var1);

    public void auditTemporaryNodes();

    public static interface Identifier {
        public static final String USER_TYPE = "user";
        public static final String GROUP_TYPE = "group";

        public @NonNull String getName();

        public @NonNull String getType();
    }
}

