/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.node.metadata;

import java.util.Objects;
import net.luckperms.api.node.metadata.NodeMetadataKey;
import org.checkerframework.checker.nullness.qual.NonNull;

final class SimpleNodeMetadataKey<T>
implements NodeMetadataKey<T> {
    private final String name;
    private final Class<T> type;

    SimpleNodeMetadataKey(String name, Class<T> type) {
        this.name = name.toLowerCase();
        this.type = type;
    }

    @Override
    public @NonNull String name() {
        return this.name;
    }

    @Override
    public @NonNull Class<T> type() {
        return this.type;
    }

    public String toString() {
        return "NodeMetadataKey(name=" + this.name + ", type=" + this.type.getName() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleNodeMetadataKey that = (SimpleNodeMetadataKey)o;
        return this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }
}

