/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;

public class DamageFilterItem
extends StringValueFilterItem {
    public StringValueData createData(ItemStack stack) {
        return new DamageData(stack);
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        DamageData data = (DamageData)this.getStringValueData(filter);
        if (data.getValue() == null) {
            return false;
        }
        int d1 = stack.func_77952_i();
        int d2 = ((DamageCheck)data.getValue()).percent ? (int)((double)(stack.func_77958_k() * ((DamageCheck)data.getValue()).damage) / 100.0) : ((DamageCheck)data.getValue()).damage;
        switch (((DamageCheck)data.getValue()).mode) {
            case 1: {
                return d1 >= d2;
            }
            case 2: {
                return d1 <= d2;
            }
            case 3: {
                return d1 > d2;
            }
            case 4: {
                return d1 < d2;
            }
        }
        return d1 == d2;
    }

    @Override
    public void getDisplayItemStacks(ItemStack filter, List<ItemStack> list) {
    }

    public static class DamageData
    extends StringValueData<DamageCheck> {
        public DamageData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        protected DamageCheck fromString(String s) {
            s = s.replaceAll("\\s", "");
            try {
                DamageCheck check = new DamageCheck();
                if (s.endsWith("%")) {
                    check.percent = true;
                    s = s.substring(0, s.length() - 1);
                }
                if (s.startsWith(">=")) {
                    check.mode = 1;
                    s = s.substring(2);
                } else if (s.startsWith("<=")) {
                    check.mode = 2;
                    s = s.substring(2);
                } else if (s.startsWith(">")) {
                    check.mode = 3;
                    s = s.substring(1);
                } else if (s.startsWith("<")) {
                    check.mode = 4;
                    s = s.substring(1);
                }
                check.damage = Integer.parseInt(s);
                return check;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        protected String toString(DamageCheck value) {
            if (value == null) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            switch (value.mode) {
                case 1: {
                    builder.append(">=");
                    break;
                }
                case 2: {
                    builder.append("<=");
                    break;
                }
                case 3: {
                    builder.append(">");
                    break;
                }
                case 4: {
                    builder.append("<");
                }
            }
            builder.append(value.damage);
            if (value.percent) {
                builder.append('%');
            }
            return builder.toString();
        }
    }

    public static class DamageCheck {
        public int mode;
        public int damage;
        public boolean percent;
    }
}

