/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.itemfilters.item;

import dev.latvian.mods.itemfilters.item.StringValueData;
import dev.latvian.mods.itemfilters.item.StringValueFilterItem;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class StrongNBTFilterItem
extends StringValueFilterItem {
    public StringValueData createData(ItemStack stack) {
        return new NBTData(stack);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND && !player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77942_o()) {
            NBTData data = (NBTData)this.getStringValueData(player.func_184614_ca());
            data.setValue(player.func_184592_cb().func_77978_p().func_74737_b());
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184614_ca());
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    public boolean filter(ItemStack filter, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        NBTData data = (NBTData)this.getStringValueData(filter);
        CompoundNBT tag1 = data.getValue();
        CompoundNBT tag2 = stack.func_77978_p();
        return Objects.equals(tag1, tag2);
    }

    public static class NBTData
    extends StringValueData<CompoundNBT> {
        public NBTData(ItemStack is) {
            super(is);
        }

        @Override
        @Nullable
        protected CompoundNBT fromString(String s) {
            if (s.isEmpty()) {
                return null;
            }
            try {
                return JsonToNBT.func_180713_a((String)s);
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        protected String toString(CompoundNBT value) {
            if (value == null) {
                return "";
            }
            return value.toString();
        }

        @Override
        @Nullable
        public CompoundNBT getValue() {
            if (this.load) {
                this.load = false;
                this.value = null;
                if (this.filter.func_77942_o() && this.filter.func_77978_p().func_74764_b("value")) {
                    this.value = this.filter.func_77978_p().func_74775_l("value");
                }
            }
            return (CompoundNBT)this.value;
        }

        @Override
        public void setValue(@Nullable CompoundNBT v) {
            this.value = v;
            this.load = false;
            if (this.value == null) {
                this.filter.func_196083_e("value");
            } else {
                this.filter.func_77983_a("value", (INBT)this.value);
            }
        }

        @Override
        public ITextComponent getValueAsComponent() {
            CompoundNBT v = this.getValue();
            if (v == null) {
                return StringTextComponent.field_240750_d_;
            }
            return v.func_197637_c();
        }
    }
}

