/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;

public class CommandSaveProfile
implements Command<CommandSource> {
    private static final CommandSaveProfile CMD = new CommandSaveProfile();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"saveprofile").requires(cs -> cs.func_197034_c(0))).then(Commands.func_197056_a((String)"profile", (ArgumentType)StringArgumentType.word()).executes((Command)CMD));
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        String name = (String)context.getArgument("profile", String.class);
        LostCityProfile profile = LostCityConfiguration.standardProfiles.get(name);
        if (profile == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Could not find profile '" + name + "'!"), true);
            return 0;
        }
        JsonObject jsonObject = profile.toJson(false);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        try (PrintWriter writer = new PrintWriter(new File(name + ".json"));){
            writer.print(gson.toJson((JsonElement)jsonObject));
            writer.flush();
        }
        catch (FileNotFoundException e) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "Error saving profile '" + name + "'!"), true);
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Saved profile '" + name + "'!"), true);
        return 0;
    }
}

