/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LandscapeType;
import mcjty.lostcities.config.LostCityProfile;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;

public class LostCityConfiguration {
    public static final String CATEGORY_GENERAL = "general";
    public static final String ADDITIONAL_DIMENSIONS_COMMENT = "List of additional Lost City dimensions. Format '<id>:<profile>'";
    public static final String LIGHTING_UPDATE_COMMENT = "List of blocks for which a lighting update is needed";
    public static final String ASSET_COMMENT = "List of asset libraries loaded in the specified order. If the path starts with '/' it is going to be loaded directly from the classpath. If the path starts with '$' it is loaded from the config directory";
    public static final String WORLDTYPES_COMMENT = "List of other worldtypes (id) that this mod will try to work with. The worldtype has to support the IChunkPrimerFactory API for this to work";
    public static final String PROFILES_COMMENT = "List of all supported profiles (used for world creation). Warning! Make sure there is always a 'default' profile!";
    public static final String PRIVATE_PROFILES_COMMENT = "List of privatep profiles that cannot be selected by the player but are only used as a child profile of another one";
    public static final String[] DEFAULT_PROFILES = new String[]{"default", "cavern", "nodamage", "rarecities", "floating", "space", "waterbubbles", "biosphere", "onlycities", "tallbuildings", "safe", "ancient", "wasteland", "chisel", "atlantis", "realistic"};
    public static final String[] PRIVATE_PROFILES = new String[]{"bio_wasteland", "water_empty"};
    public static String[] BLOCKS_REQUIRING_LIGHTING_UPDATES = new String[]{"minecraft:glowstone", "minecraft:lit_pumpkin", "minecraft:magma"};
    public static String[] ADDITIONAL_DIMENSIONS = new String[0];
    public static String[] ADAPTING_WORLDTYPES = new String[0];
    public static int VERSION = 7;
    public static final Map<String, LostCityProfile> profiles = new HashMap<String, LostCityProfile>();
    public static final Map<String, LostCityProfile> standardProfiles = new HashMap<String, LostCityProfile>();
    public static String DIMENSION_PROFILE = "default";
    public static String DEFAULT_PROFILE = "default";
    public static boolean DIMENSION_BOP = true;
    public static boolean DEBUG = false;
    public static ForgeConfigSpec.ConfigValue<String> SPECIAL_BED_BLOCK;

    public static void init(ForgeConfigSpec.Builder SERVER_BUILDER) {
        SERVER_BUILDER.comment("General settings").push(CATEGORY_GENERAL);
        SPECIAL_BED_BLOCK = SERVER_BUILDER.comment("Block to put underneath a bed so that it qualifies as a teleporter bed").define("specialBedBlock", (Object)"minecraft:diamond_block");
        SERVER_BUILDER.pop();
    }

    private static void initStandardProfiles() {
        LostCityProfile profile = new LostCityProfile("default", true);
        profile.setIconFile("textures/gui/icon_default.png");
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("cavern", true);
        profile.setDescription("This is a cavern type world (like the nether)");
        profile.setExtraDescription("There are lights in the building but the outside is very dark. Warning! This is pretty heavy on performance!");
        profile.setIconFile("textures/gui/icon_cavern.png");
        profile.LANDSCAPE_TYPE = LandscapeType.CAVERN;
        profile.HORIZON = 128.0f;
        profile.FOG_RED = 0.0f;
        profile.FOG_GREEN = 0.0f;
        profile.FOG_BLUE = 0.0f;
        profile.FOG_DENSITY = 0.02f;
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.0f;
        profile.GENERATE_LIGHTING = true;
        profile.GENERATE_LAKES = false;
        profile.GENERATE_VILLAGES = false;
        profile.RAILWAYS_ENABLED = false;
        profile.GROUNDLEVEL = 40;
        profile.SEALEVEL = 32;
        profile.CITY_LEVEL0_HEIGHT = 44;
        profile.CITY_LEVEL1_HEIGHT = 52;
        profile.CITY_LEVEL2_HEIGHT = 60;
        profile.CITY_LEVEL3_HEIGHT = 68;
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("nodamage", true);
        profile.setDescription("Like default but no explosion damage");
        profile.setExtraDescription("Ruins and rubble are disabled and ravines are disabled in cities");
        profile.setIconFile("textures/gui/icon_nodamage.png");
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.0f;
        profile.RUIN_CHANCE = 0.0f;
        profile.RUBBLELAYER = false;
        profile.PREVENT_LAKES_RAVINES_IN_CITIES = true;
        profile.MAX_CAVE_HEIGHT = 64;
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("rarecities", true);
        profile.setDescription("Cities are rare");
        profile.setIconFile("textures/gui/icon_rarecities.png");
        profile.CITY_CHANCE = 0.001f;
        profile.RUIN_CHANCE = 0.0f;
        profile.HIGHWAY_REQUIRES_TWO_CITIES = false;
        profile.RAILWAYS_CAN_END = true;
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("onlycities", true);
        profile.setDescription("The entire world is a city");
        profile.setIconFile("textures/gui/icon_onlycities.png");
        profile.CITY_CHANCE = 0.2f;
        profile.CITY_MAXRADIUS = 256;
        profile.CITY_BIOME_FACTORS = new String[]{"river=.5", "frozen_river=.5", "ocean=.7", "frozen_ocean=.7", "deep_ocean=.6"};
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("tallbuildings", true);
        profile.setDescription("Very tall buildings (performance heavy)");
        profile.setIconFile("textures/gui/icon_tallbuildings.png");
        profile.BUILDING_MINFLOORS = 4;
        profile.BUILDING_MINFLOORS_CHANCE = 8;
        profile.BUILDING_MAXFLOORS_CHANCE = 15;
        profile.BUILDING_MAXFLOORS = 19;
        profile.DEBRIS_TO_NEARBYCHUNK_FACTOR = 175;
        profile.DESTROY_LONE_BLOCKS_FACTOR = 0.08f;
        profile.DESTROY_OR_MOVE_CHANCE = 0.2f;
        profile.EXPLOSION_CHANCE = 0.006f;
        profile.EXPLOSION_MAXHEIGHT = 256;
        profile.EXPLOSION_MAXRADIUS = 60;
        profile.EXPLOSION_MINHEIGHT = 130;
        profile.MINI_EXPLOSION_CHANCE = 0.09f;
        profile.MINI_EXPLOSION_MAXHEIGHT = 256;
        profile.MINI_EXPLOSION_MAXRADIUS = 14;
        profile.MINI_EXPLOSION_MINRADIUS = 3;
        profile.RUIN_CHANCE = 0.01f;
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("safe", true);
        profile.setDescription("Safe mode: no spawners, lighting but no loot");
        profile.setIconFile("textures/gui/icon_safe.png");
        profile.GENERATE_SPAWNERS = false;
        profile.GENERATE_LIGHTING = true;
        profile.GENERATE_LOOT = false;
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("ancient", true);
        profile.setDescription("Ancient jungle city, vines and leafs, ruined buildings");
        profile.setExtraDescription("Note! This disables many biomes like deserts, plains, extreme hills, ...");
        profile.setIconFile("textures/gui/icon_ancient.png");
        profile.THICKNESS_OF_RANDOM_LEAFBLOCKS = 6;
        profile.CHANCE_OF_RANDOM_LEAFBLOCKS = 0.05f;
        profile.VINE_CHANCE = 0.1f;
        profile.EXPLOSION_CHANCE = 0.0f;
        profile.MINI_EXPLOSION_CHANCE = 0.0f;
        profile.RUBBLELAYER = true;
        profile.RUBBLE_DIRT_SCALE = 2.0f;
        profile.RUBBLE_LEAVE_SCALE = 2.0f;
        profile.RUIN_CHANCE = 0.9f;
        profile.RUIN_MINLEVEL_PERCENT = 0.0f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.8f;
        profile.ALLOWED_BIOME_FACTORS = new String[]{"jungle=1", "jungle_hills=1", "jungle_edge=2", "ocean=8", "beaches=20", "river=5"};
        standardProfiles.put(profile.getName(), profile);
        profile = new LostCityProfile("wasteland", true);
        profile.setDescription("Wasteland, no water, bare land");
        profile.setExtraDescription("This profile works best with Biomes O Plenty");
        profile.setIconFile("textures/gui/icon_wasteland.png");
        profile.GENERATE_LAKES = false;
        profile.GENERATE_OCEANMONUMENTS = false;
        profile.VINE_CHANCE = 0.003f;
        profile.CHANCE_OF_RANDOM_LEAFBLOCKS = 0.01f;
        profile.RUBBLELAYER = true;
        profile.RUBBLE_DIRT_SCALE = 2.0f;
        profile.RUBBLE_LEAVE_SCALE = 0.0f;
        profile.RUIN_CHANCE = 0.5f;
        profile.RUIN_MINLEVEL_PERCENT = 0.5f;
        profile.RUIN_MAXLEVEL_PERCENT = 0.9f;
        profile.AVOID_WATER = true;
        profile.AVOID_FOLIAGE = true;
        profile.AVOID_GENERATED_LAKE_WATER = true;
        profile.AVOID_GENERATED_LILYPADS = true;
        profile.AVOID_GENERATED_FLOWERS = true;
        profile.AVOID_GENERATED_REEDS = true;
        profile.ALLOWED_BIOME_FACTORS = new String[]{"desert=1", "desert_hills=1", "stone_beach=1", "dead_forest=1", "gravel_beach=1", "outback=1", "volcanic_island=1", "wasteland=.3"};
        standardProfiles.put(profile.getName(), profile);
    }

    public static void setupProfiles() {
        Path path = FMLPaths.CONFIGDIR.get();
        Path profileDir = Paths.get(path.toString(), "lostcities/profiles");
        LostCities.getLogger().info("Creating standard profiles into 'config/lostcities/profiles'");
        LostCityConfiguration.initStandardProfiles();
        new File(profileDir.toString()).mkdirs();
        for (Map.Entry<String, LostCityProfile> entry : standardProfiles.entrySet()) {
            String name = entry.getKey();
            if ("customized".equals(name)) continue;
            LostCityProfile profile = entry.getValue();
            JsonObject jsonObject = profile.toJson(true);
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            try {
                PrintWriter writer = new PrintWriter(new File(profileDir.toString(), name + ".json"));
                Throwable throwable = null;
                try {
                    writer.print(gson.toJson((JsonElement)jsonObject));
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (writer == null) continue;
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    writer.close();
                }
            }
            catch (FileNotFoundException e) {
                LostCities.getLogger().error("Couldn't save profile '" + name + "'!");
            }
        }
        LostCities.getLogger().info("Reading existing profiles from 'config/lostcities/profiles'");
        LostCityConfiguration.readProfiles(profileDir);
    }

    private static void readProfiles(Path profileDir) {
        File[] files;
        for (File file : files = new File(profileDir.toString()).listFiles((dir, name) -> name.endsWith(".json"))) {
            String name2 = file.getName();
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                String[] split = name2.split("\\.");
                LostCityProfile profile = new LostCityProfile(split[0], json);
                standardProfiles.put(split[0], profile);
            }
            catch (IOException e) {
                LostCities.getLogger().error("Couldn't read profile '" + name2 + "'!");
                return;
            }
        }
    }
}

