/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.worldgen.ChunkHeightmap;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityTerrainFeature;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.WorldStyle;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.server.ServerChunkProvider;

public class DefaultDimensionInfo
implements IDimensionInfo {
    private ISeedReader world;
    private final LostCityProfile profile;
    private final WorldStyle style;
    private final Registry<Biome> biomeRegistry;
    private final LostCityTerrainFeature feature;

    public DefaultDimensionInfo(ISeedReader world, LostCityProfile profile) {
        this.world = world;
        this.profile = profile;
        this.style = AssetRegistries.WORLDSTYLES.get("standard");
        this.feature = new LostCityTerrainFeature(this, profile, this.getRandom());
        this.feature.setupStates(profile);
        this.biomeRegistry = (Registry)DynamicRegistries.func_239770_b_().func_230521_a_(Registry.field_239720_u_).get();
    }

    @Override
    public void setWorld(ISeedReader world) {
        this.world = world;
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public ISeedReader getWorld() {
        return this.world;
    }

    @Override
    public RegistryKey<World> getType() {
        return this.world.func_201672_e().func_234923_W_();
    }

    @Override
    public LostCityProfile getProfile() {
        return this.profile;
    }

    @Override
    public LostCityProfile getOutsideProfile() {
        return null;
    }

    @Override
    public WorldStyle getWorldStyle() {
        return this.style;
    }

    @Override
    public Random getRandom() {
        return this.world.func_201674_k();
    }

    @Override
    public LostCityTerrainFeature getFeature() {
        return this.feature;
    }

    @Override
    public ChunkHeightmap getHeightmap(int chunkX, int chunkZ) {
        return this.feature.getHeightmap(chunkX, chunkZ, this.getWorld());
    }

    @Override
    public Biome getBiome(BlockPos pos) {
        AbstractChunkProvider chunkProvider = this.getWorld().func_72863_F();
        if (chunkProvider instanceof ServerChunkProvider) {
            BiomeProvider biomeProvider = ((ServerChunkProvider)chunkProvider).func_201711_g().func_202090_b();
            return biomeProvider.func_225526_b_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return (Biome)this.biomeRegistry.func_241873_b(Biomes.field_76772_c.func_240901_a_()).get();
    }
}

