/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.client.gui.BlackBoardGui;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;

public class BlackboardBlock
extends WaterBlock {
    public static final VoxelShape SHAPE_SOUTH = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    public static final VoxelShape SHAPE_NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPE_WEST = Block.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public BlackboardBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity te;
        super.func_180633_a(world, pos, state, placer, stack);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && (te = world.func_175625_s(pos)) instanceof BlackboardBlockTile && compoundnbt.func_74764_b("pixels_0")) {
            for (int i = 0; i < 16; ++i) {
                byte[] b = compoundnbt.func_74770_j("pixels_" + i);
                if (b.length != 16) continue;
                ((BlackboardBlockTile)te).pixels[i] = b;
            }
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            default: {
                return SHAPE_NORTH;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case WEST: 
        }
        return SHAPE_WEST;
    }

    private static byte colorToByte(DyeColor color) {
        switch (color) {
            case BLACK: {
                return 0;
            }
            case WHITE: {
                return 1;
            }
            case ORANGE: {
                return 15;
            }
        }
        return (byte)color.func_196059_a();
    }

    public static int colorFromByte(byte b) {
        switch (b) {
            case 0: 
            case 1: {
                return 0xFFFFFF;
            }
            case 15: {
                return DyeColor.ORANGE.getColorValue();
            }
        }
        return DyeColor.func_196056_a((int)b).getColorValue();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof BlackboardBlockTile) {
            BlackboardBlockTile te = (BlackboardBlockTile)tileentity;
            if (hit.func_216354_b() == state.func_177229_b((Property)FACING)) {
                DyeColor col;
                ItemStack stack = player.func_184586_b(handIn);
                Item item2 = stack.func_77973_b();
                Vector3d v2 = hit.func_216347_e();
                Vector3d v = v2.func_178785_b((float)((double)hit.func_216354_b().func_185119_l() * Math.PI / 180.0));
                double fx = v.field_72450_a % 1.0 * 16.0;
                if (fx < 0.0) {
                    fx += 16.0;
                }
                int x = MathHelper.func_76125_a((int)((int)fx), (int)-15, (int)15);
                int y = 15 - (int)MathHelper.func_151237_a((double)Math.abs(v.field_72448_b % 1.0 * 16.0), (double)0.0, (double)15.0);
                if (ServerConfigs.cached.BLACKBOARD_COLOR && (col = DyeColor.getColor((ItemStack)stack)) != null) {
                    te.pixels[x][y] = BlackboardBlock.colorToByte(col);
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
                if (item2 == Items.field_151128_bU || item2.func_206844_a((ITag)Tags.Items.DYES_WHITE)) {
                    te.pixels[x][y] = 1;
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
                if (item2 == Items.field_151044_h || item2 == Items.field_196155_l || item2.func_206844_a((ITag)Tags.Items.DYES_BLACK)) {
                    te.pixels[x][y] = 0;
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
                if (item2 == Items.field_221646_ak || item2 == Items.field_221648_al) {
                    te.pixels = new byte[16][16];
                    return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
                }
            }
            if (worldIn.func_201670_d()) {
                BlackBoardGui.open(te);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BlackboardBlockTile();
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.blackboard").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public ItemStack getBlackboardItem(BlackboardBlockTile te) {
        CompoundNBT compoundnbt;
        ItemStack itemstack = new ItemStack((IItemProvider)this);
        if (!te.isEmpty() && !(compoundnbt = te.saveItemNBT(new CompoundNBT())).isEmpty()) {
            itemstack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
        }
        return itemstack;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        TileEntity tileentity = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (tileentity instanceof BlackboardBlockTile) {
            ItemStack itemstack = this.getBlackboardItem((BlackboardBlockTile)tileentity);
            return Collections.singletonList(itemstack);
        }
        return super.func_220076_a(state, builder);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BlackboardBlockTile) {
            return this.getBlackboardItem((BlackboardBlockTile)te);
        }
        return super.getPickBlock(state, target, world, pos, player);
    }
}

