/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.block.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.GlobeBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GlobeBlock
extends WaterBlock {
    protected static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)1.0, (double)0.875);
    public static final BooleanProperty TRIGGERED = BlockStateProperties.field_208197_x;
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;

    public GlobeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (!ClientConfigs.cached.TOOLTIP_HINTS || !Minecraft.func_71410_x().field_71474_y.field_82882_x) {
            return;
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("message.supplementaries.globe").func_240699_a_(TextFormatting.ITALIC).func_240699_a_(TextFormatting.GRAY));
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        this.updatePower(state, worldIn, pos);
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof GlobeBlockTile) {
            ((GlobeBlockTile)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    public void updatePower(BlockState state, World world, BlockPos pos) {
        boolean powered;
        boolean bl = powered = world.func_175687_A(pos) > 0;
        if (powered != (Boolean)state.func_177229_b((Property)TRIGGERED)) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)TRIGGERED, (Comparable)Boolean.valueOf(powered)), 4);
            if (powered) {
                world.func_175641_c(pos, state.func_177230_c(), 1, 0);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te;
        if (player.func_184586_b(handIn).func_77973_b() instanceof ShearsItem && (te = worldIn.func_175625_s(pos)) instanceof GlobeBlockTile && ((GlobeBlockTile)te).field_200663_e == GlobeBlockTile.GlobeType.DEFAULT) {
            ((GlobeBlockTile)te).field_200663_e = GlobeBlockTile.GlobeType.SHEARED;
            if (worldIn.field_72995_K) {
                Minecraft.func_71410_x().field_71452_i.func_180533_a(pos, state);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (!worldIn.field_72995_K) {
            worldIn.func_175641_c(pos, state.func_177230_c(), 1, 0);
        } else {
            player.func_146105_b((ITextComponent)new StringTextComponent("X: " + pos.func_177958_n() + ", Z: " + pos.func_177952_p()), true);
        }
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (CommonUtil.FESTIVITY.isEarthDay() && worldIn.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int l = 0; l < 1; ++l) {
                double d0 = (double)x + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                double d1 = (double)y + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                double d2 = (double)z + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.625;
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, moving);
        this.updatePower(state, world, pos);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing == Direction.DOWN && !this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return !worldIn.func_175623_d(pos.func_177977_b());
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED, FACING, TRIGGERED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean flag = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new GlobeBlockTile();
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int eventID, int eventParam) {
        super.func_189539_a(state, world, pos, eventID, eventParam);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(eventID, eventParam);
    }

    public boolean func_149740_M(@Nonnull BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof GlobeBlockTile) {
            if (((GlobeBlockTile)te).yaw != 0.0f) {
                return 15;
            }
            return ((GlobeBlockTile)te).face / -90 + 1;
        }
        return 0;
    }
}

