/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.tiles.PedestalBlockTile;
import net.mehvahdjukaar.supplementaries.items.SackItem;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class PedestalBlock
extends Block
implements IWaterLoggable {
    protected static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)VoxelShapes.func_197873_a((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape[])new VoxelShape[]{VoxelShapes.func_197873_a((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375), VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375)});
    protected static final VoxelShape SHAPE_UP = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197873_a((double)0.1875, (double)0.125, (double)0.1875, (double)0.815, (double)1.0, (double)0.815), (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.0, (double)0.0625, (double)0.9375, (double)0.1875, (double)0.9375));
    protected static final VoxelShape SHAPE_DOWN = VoxelShapes.func_197872_a((VoxelShape)VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)0.885, (double)0.815), (VoxelShape)VoxelShapes.func_197873_a((double)0.0625, (double)0.8125, (double)0.0625, (double)0.9375, (double)1.0, (double)0.9375));
    protected static final VoxelShape SHAPE_UP_DOWN = VoxelShapes.func_197873_a((double)0.1875, (double)0.0, (double)0.1875, (double)0.815, (double)1.0, (double)0.815);
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty HAS_ITEM = BlockProperties.HAS_ITEM;

    public PedestalBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_ITEM, (Comparable)Boolean.valueOf(false)));
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof PedestalBlockTile && ((PedestalBlockTile)te).field_200663_e == PedestalBlockTile.DisplayType.CRYSTAL) {
            return 3.0f;
        }
        return 0.0f;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{UP, DOWN, WATERLOGGED, HAS_ITEM});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        boolean flag = world.func_204610_c(pos = context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(world.func_180495_p(pos.func_177984_a()), pos, (IWorld)world, Direction.UP, false)))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(world.func_180495_p(pos.func_177977_b()), pos, (IWorld)world, Direction.DOWN, false)));
    }

    public static boolean canConnect(BlockState state, BlockPos pos, IWorld world, Direction dir, boolean hasItem) {
        if (state.func_177230_c() instanceof PedestalBlock) {
            if (dir == Direction.DOWN) {
                return (Boolean)state.func_177229_b((Property)HAS_ITEM) == false;
            }
            if (dir == Direction.UP) {
                return !hasItem;
            }
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (facing == Direction.UP) {
            return (BlockState)stateIn.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(facingState, currentPos, worldIn, facing, (Boolean)stateIn.func_177229_b((Property)HAS_ITEM))));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(PedestalBlock.canConnect(facingState, currentPos, worldIn, facing, (Boolean)stateIn.func_177229_b((Property)HAS_ITEM))));
        }
        return stateIn;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack i;
        TileEntity te = world.func_175625_s(pos);
        if (target.func_216347_e().func_82617_b() > (double)(pos.func_177956_o() + 1) - 0.1875 && te instanceof ItemDisplayTile && !(i = ((ItemDisplayTile)te).getDisplayedItem()).func_190926_b()) {
            return i;
        }
        return new ItemStack((IItemProvider)this, 1);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof PedestalBlockTile) {
            ActionResultType resultType;
            PedestalBlockTile te = (PedestalBlockTile)tileentity;
            ItemStack handItem = player.func_184586_b(handIn);
            if (handItem.func_77973_b() instanceof SackItem) {
                ItemStack it = handItem.func_77946_l();
                it.func_190920_e(1);
                ItemStack removed = te.func_70304_b(0);
                te.setDisplayedItem(it);
                if (!player.func_184812_l_()) {
                    handItem.func_190918_g(1);
                }
                if (!worldIn.func_201670_d()) {
                    player.func_184611_a(handIn, removed);
                    worldIn.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.95f);
                    te.func_70296_d();
                } else {
                    te.updateClientVisuals();
                }
                resultType = ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
            } else {
                resultType = te.interact(player, handIn);
            }
            if (resultType.func_226246_a_()) {
                te.yaw = player.func_174811_aO().func_176740_k() == Direction.Axis.X ? 90.0f : 0.0f;
                return resultType;
            }
        }
        return ActionResultType.PASS;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        boolean up = (Boolean)state.func_177229_b((Property)UP);
        boolean down = (Boolean)state.func_177229_b((Property)DOWN);
        if (!up) {
            if (!down) {
                return SHAPE;
            }
            return SHAPE_DOWN;
        }
        if (!down) {
            return SHAPE_UP;
        }
        return SHAPE_UP_DOWN;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        return tileEntity instanceof INamedContainerProvider ? (INamedContainerProvider)tileEntity : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new PedestalBlockTile();
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = world.func_175625_s(pos);
            if (tileentity instanceof PedestalBlockTile) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((PedestalBlockTile)tileentity));
                world.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof PedestalBlockTile) {
            return Container.func_94526_b((IInventory)((IInventory)tileentity));
        }
        return 0;
    }
}

