/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.PulleyBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.PlayerlessContext;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.decorativeblocks.RopeChandelierBlock;
import net.mehvahdjukaar.supplementaries.compat.quark.QuarkPistonPlugin;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BellBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CauldronBlock;
import net.minecraft.block.ChainBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RopeBlock
extends Block
implements IWaterLoggable {
    private final Map<BlockState, VoxelShape> SHAPES_MAP = new HashMap<BlockState, VoxelShape>();
    public static final EnumProperty<BlockProperties.RopeAttachment> NORTH = BlockProperties.CONNECTION_NORTH;
    public static final EnumProperty<BlockProperties.RopeAttachment> SOUTH = BlockProperties.CONNECTION_SOUTH;
    public static final EnumProperty<BlockProperties.RopeAttachment> EAST = BlockProperties.CONNECTION_EAST;
    public static final EnumProperty<BlockProperties.RopeAttachment> WEST = BlockProperties.CONNECTION_WEST;
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final IntegerProperty DISTANCE = BlockStateProperties.field_222510_au;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty KNOT = BlockProperties.KNOT;
    public static final Map<Direction, EnumProperty<BlockProperties.RopeAttachment>> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
    });
    private static final VoxelShape COLLISION_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);

    public RopeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.makeShapes();
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(7))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(NORTH, (Comparable)((Object)BlockProperties.RopeAttachment.NONE))).func_206870_a(SOUTH, (Comparable)((Object)BlockProperties.RopeAttachment.NONE))).func_206870_a(EAST, (Comparable)((Object)BlockProperties.RopeAttachment.NONE))).func_206870_a(WEST, (Comparable)((Object)BlockProperties.RopeAttachment.NONE)));
    }

    public boolean func_225541_a_(BlockState state, Fluid fluid) {
        return false;
    }

    public boolean isProtruding(BlockState state) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.SHAPES_MAP.getOrDefault(((BlockState)((BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(0))).func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), VoxelShapes.func_197868_b());
    }

    protected void makeShapes() {
        VoxelShape down = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape up = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.func_208617_a((double)6.0, (double)9.0, (double)0.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape south = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)16.0);
        VoxelShape west = Block.func_208617_a((double)0.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape east = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)16.0, (double)13.0, (double)10.0);
        VoxelShape knot = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape northEx = Block.func_208617_a((double)6.0, (double)9.0, (double)-6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape southEx = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)22.0);
        VoxelShape westEx = Block.func_208617_a((double)-6.0, (double)9.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0);
        VoxelShape eastEx = Block.func_208617_a((double)6.0, (double)9.0, (double)6.0, (double)22.0, (double)13.0, (double)10.0);
        for (BlockState state : this.field_176227_L.func_177619_a()) {
            if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue() || (Integer)state.func_177229_b((Property)DISTANCE) != 0 || !((Boolean)state.func_177229_b((Property)KNOT)).booleanValue()) continue;
            VoxelShape v = VoxelShapes.func_216384_a((VoxelShape)knot, (VoxelShape[])new VoxelShape[0]);
            if (((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)down);
            }
            if (((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)up);
            }
            if (((BlockProperties.RopeAttachment)((Object)state.func_177229_b(NORTH))).isBlock()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)north);
            } else if (!((BlockProperties.RopeAttachment)((Object)state.func_177229_b(NORTH))).isNone()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)northEx);
            }
            if (((BlockProperties.RopeAttachment)((Object)state.func_177229_b(SOUTH))).isBlock()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)south);
            } else if (!((BlockProperties.RopeAttachment)((Object)state.func_177229_b(SOUTH))).isNone()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)southEx);
            }
            if (((BlockProperties.RopeAttachment)((Object)state.func_177229_b(WEST))).isBlock()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)west);
            } else if (!((BlockProperties.RopeAttachment)((Object)state.func_177229_b(WEST))).isNone()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)westEx);
            }
            if (((BlockProperties.RopeAttachment)((Object)state.func_177229_b(EAST))).isBlock()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)east);
            } else if (!((BlockProperties.RopeAttachment)((Object)state.func_177229_b(EAST))).isNone()) {
                v = VoxelShapes.func_197872_a((VoxelShape)v, (VoxelShape)eastEx);
            }
            v = v.func_197753_c();
            boolean flag = true;
            for (VoxelShape existing : this.SHAPES_MAP.values()) {
                if (!existing.equals(v)) continue;
                this.SHAPES_MAP.put(state, existing);
                flag = false;
                break;
            }
            if (!flag) continue;
            this.SHAPES_MAP.put(state, v);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, SOUTH, EAST, WEST, UP, DOWN, WATERLOGGED, DISTANCE, KNOT});
    }

    public boolean isLadder(BlockState state, IWorldReader world, BlockPos pos, LivingEntity entity2) {
        return (Boolean)state.func_177229_b((Property)DOWN) != false && ((Boolean)state.func_177229_b((Property)UP) != false || entity2.func_213303_ch().func_82617_b() - (double)pos.func_177956_o() < 0.8125);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return (Boolean)state.func_177229_b((Property)UP) == false && (context.func_216378_a(COLLISION_SHAPE, pos, true) || (Boolean)state.func_177229_b((Property)DOWN) == false) || !(context.getEntity() instanceof LivingEntity) ? this.func_220053_a(state, worldIn, pos, context) : VoxelShapes.func_197880_a();
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
        if (newState.func_177230_c() != this) {
            for (Direction d : FACING_TO_PROPERTY_MAP.keySet()) {
                if (!((BlockProperties.RopeAttachment)((Object)state.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(d)))).isKnot()) continue;
                this.updateFenceNeighbours(pos, d, worldIn);
            }
        }
    }

    public void updateFenceNeighbours(BlockPos myPos, Direction facingDir, World world) {
        BlockPos fencePos = myPos.func_177972_a(facingDir);
        BlockState fence = world.func_180495_p(fencePos);
        if (CommonUtil.isPost(fence)) {
            for (Direction d : FACING_TO_PROPERTY_MAP.keySet()) {
                BlockPos ropePos;
                BlockState rope;
                if (d == facingDir.func_176734_d() || !((rope = world.func_180495_p(ropePos = fencePos.func_177972_a(d))).func_177230_c() instanceof RopeBlock)) continue;
                world.func_180501_a(ropePos, (BlockState)rope.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(d.func_176734_d()), (Comparable)((Object)BlockProperties.RopeAttachment.KNOT)), 18);
                return;
            }
        }
    }

    public BlockProperties.RopeAttachment getAttachment(BlockPos currentPos, IWorld world, Direction dir) {
        BlockPos facingPos = currentPos.func_177972_a(dir);
        BlockState facingState = world.func_180495_p(facingPos);
        Block b = facingState.func_177230_c();
        if (b == this) {
            return BlockProperties.RopeAttachment.BLOCK;
        }
        if (CommonUtil.isPost(facingState)) {
            if (this.checkForKnot(facingPos, world, dir)) {
                return BlockProperties.RopeAttachment.KNOT;
            }
            return BlockProperties.RopeAttachment.FENCE;
        }
        return BlockProperties.RopeAttachment.NONE;
    }

    private boolean checkForKnot(BlockPos fencePos, IWorld world, Direction myDir) {
        for (Direction d : FACING_TO_PROPERTY_MAP.keySet()) {
            BlockState state;
            if (d == myDir.func_176734_d() || !((state = world.func_180495_p(fencePos.func_177972_a(d))).func_177230_c() instanceof RopeBlock)) continue;
            if (((BlockProperties.RopeAttachment)((Object)state.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(d.func_176734_d())))).isKnot()) {
                return false;
            }
            if (d.ordinal() <= myDir.ordinal()) continue;
            return false;
        }
        return true;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        if (!worldIn.func_201670_d()) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
        }
        if (facing == Direction.UP) {
            boolean up = RopeBlock.isSupportingCeiling(facingPos, (IWorldReader)worldIn);
            boolean down = up || RopeBlock.canConnectDown(currentPos, (IWorldReader)worldIn);
            stateIn = (BlockState)((BlockState)stateIn.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(up))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(down));
        } else if (facing == Direction.DOWN) {
            boolean down = RopeBlock.canConnectDown(currentPos, (IWorldReader)worldIn) || (Boolean)stateIn.func_177229_b((Property)UP) != false;
            stateIn = (BlockState)stateIn.func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(down));
            if (!worldIn.func_201670_d() && CompatHandler.deco_blocks) {
                RopeChandelierBlock.tryConverting(facingState, worldIn, facingPos);
            }
        } else {
            stateIn = (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)((Object)this.getAttachment(currentPos, worldIn, facing)));
        }
        return (BlockState)stateIn.func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(RopeBlock.hasMiddleKnot(stateIn)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        boolean hasWater = context.func_195991_k().func_204610_c(pos).func_206886_c() == Fluids.field_204546_a;
        BlockState state = this.func_176223_P();
        for (Direction dir : FACING_TO_PROPERTY_MAP.keySet()) {
            state = (BlockState)state.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(dir), (Comparable)((Object)this.getAttachment(pos, (IWorld)world, dir)));
        }
        boolean up = RopeBlock.isSupportingCeiling(pos.func_177984_a(), (IWorldReader)world);
        boolean down = up || RopeBlock.canConnectDown(pos, (IWorldReader)world);
        state = (BlockState)((BlockState)((BlockState)state.func_206870_a((Property)UP, (Comparable)Boolean.valueOf(up))).func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(down))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        state = (BlockState)((BlockState)state.func_206870_a((Property)KNOT, (Comparable)Boolean.valueOf(RopeBlock.hasMiddleKnot(state)))).func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(RopeBlock.getDistance((IWorldReader)world, pos)));
        return state;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 1);
            if (CompatHandler.deco_blocks) {
                BlockPos down = pos.func_177977_b();
                RopeChandelierBlock.tryConverting(worldIn.func_180495_p(down), (IWorld)worldIn, down);
            }
        }
    }

    public static boolean hasMiddleKnot(BlockState state) {
        boolean up = (Boolean)state.func_177229_b((Property)UP);
        boolean down = (Boolean)state.func_177229_b((Property)DOWN);
        BlockProperties.RopeAttachment north = (BlockProperties.RopeAttachment)((Object)state.func_177229_b(NORTH));
        BlockProperties.RopeAttachment east = (BlockProperties.RopeAttachment)((Object)state.func_177229_b(EAST));
        BlockProperties.RopeAttachment south = (BlockProperties.RopeAttachment)((Object)state.func_177229_b(SOUTH));
        BlockProperties.RopeAttachment west = (BlockProperties.RopeAttachment)((Object)state.func_177229_b(WEST));
        return !(up && down && north.isNone() && south.isNone() && east.isNone() && west.isNone() || !up && !down && !north.isNone() && !south.isNone() && east.isNone() && west.isNone() || !up && !down && north.isNone() && south.isNone() && !east.isNone() && !west.isNone());
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return RopeBlock.getDistance(worldIn, pos) < 7;
    }

    public static boolean isSupportingCeiling(BlockPos pos, IWorldReader world) {
        Block b = world.func_180495_p(pos).func_177230_c();
        return RopeBlock.func_220055_a((IWorldReader)world, (BlockPos)pos, (Direction)Direction.DOWN) || ModTags.isTagged(ModTags.ROPE_SUPPORT_TAG, b);
    }

    public static boolean canConnectDown(BlockPos currentPos, IWorldReader world) {
        BlockState state = world.func_180495_p(currentPos.func_177977_b());
        Block b = state.func_177230_c();
        return b instanceof RopeBlock || ModTags.isTagged(ModTags.ROPE_HANG_TAG, b) || state.func_235901_b_((Property)HorizontalFaceBlock.field_196366_M) && state.func_177229_b((Property)HorizontalFaceBlock.field_196366_M) == AttachFace.CEILING || b instanceof ChainBlock && state.func_177229_b((Property)BlockStateProperties.field_208148_A) == Direction.Axis.Y || state.func_235901_b_((Property)BlockStateProperties.field_222514_j) && (Boolean)state.func_177229_b((Property)BlockStateProperties.field_222514_j) != false;
    }

    public static int getDistance(IWorldReader world, BlockPos pos) {
        BlockPos.Mutable mutable = pos.func_239590_i_().func_189536_c(Direction.UP);
        BlockState blockstate = world.func_180495_p((BlockPos)mutable);
        int i = 7;
        if (blockstate.func_177230_c() instanceof RopeBlock) {
            i = (Integer)blockstate.func_177229_b((Property)DISTANCE);
        } else if (RopeBlock.isSupportingCeiling((BlockPos)mutable, world)) {
            return 0;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState side = world.func_180495_p((BlockPos)mutable.func_239622_a_((Vector3i)pos, direction));
            Block b = side.func_177230_c();
            if (b instanceof RopeBlock) {
                if ((i = Math.min(i, (Integer)side.func_177229_b((Property)DISTANCE) + 1)) != 1) continue;
                break;
            }
            if (!CommonUtil.isPost(side)) continue;
            i = 0;
        }
        return i;
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        int i = RopeBlock.getDistance((IWorldReader)worldIn, pos);
        BlockState blockstate = (BlockState)state.func_206870_a((Property)DISTANCE, (Comparable)Integer.valueOf(i));
        if (i == 7) {
            worldIn.func_175655_b(pos, true);
        } else if (state != blockstate) {
            worldIn.func_180501_a(pos, blockstate, 3);
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public int getFireSpreadSpeed(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, IBlockReader world, BlockPos pos, Direction face) {
        return 60;
    }

    private static boolean findConnectedBell(World world, BlockPos pos, PlayerEntity player, int it) {
        if (it > ServerConfigs.cached.BELL_CHAIN_LENGTH) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof RopeBlock) {
            return RopeBlock.findConnectedBell(world, pos.func_177984_a(), player, it + 1);
        }
        if (b instanceof BellBlock && it != 0) {
            boolean success = ((BellBlock)b).func_226885_a_(world, pos, ((Direction)state.func_177229_b((Property)BellBlock.field_220133_a)).func_176746_e());
            if (success && player != null) {
                player.func_195066_a(Stats.field_219740_ax);
            }
            return true;
        }
        return false;
    }

    private static boolean findConnectedPulley(World world, BlockPos pos, PlayerEntity player, int it, Rotation rot) {
        TileEntity te;
        if (it > 64) {
            return false;
        }
        BlockState state = world.func_180495_p(pos);
        Block b = state.func_177230_c();
        if (b instanceof RopeBlock) {
            return RopeBlock.findConnectedPulley(world, pos.func_177984_a(), player, it + 1, rot);
        }
        if (b instanceof PulleyBlock && it != 0 && (te = world.func_175625_s(pos)) instanceof PulleyBlockTile) {
            PulleyBlockTile tile = (PulleyBlockTile)te;
            if (tile.func_191420_l() && !player.func_225608_bj_()) {
                tile.setDisplayedItem(new ItemStack((IItemProvider)Registry.ROPE_ITEM.get()));
                boolean ret = ((PulleyBlock)b).axisRotate(state, pos, world, rot);
                tile.getDisplayedItem().func_190918_g(1);
                return ret;
            }
            return ((PulleyBlock)b).axisRotate(state, pos, world, rot);
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(handIn);
        if (stack.func_77973_b() == this.func_199767_j()) {
            if ((hit.func_216354_b().func_176740_k() == Direction.Axis.Y || ((Boolean)state.func_177229_b((Property)DOWN)).booleanValue()) && RopeBlock.addRope(pos.func_177977_b(), world, player, handIn, this)) {
                SoundType soundtype = state.getSoundType((IWorldReader)world, pos, (Entity)player);
                world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                if (player == null || !player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            return ActionResultType.PASS;
        }
        if (stack.func_190926_b() && ((Boolean)state.func_177229_b((Property)UP)).booleanValue()) {
            if (ServerConfigs.cached.BELL_CHAIN && RopeBlock.findConnectedBell(world, pos, player, 0)) {
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
            if (RopeBlock.findConnectedPulley(world, pos, player, 0, player.func_225608_bj_() ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90)) {
                return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
            }
        }
        if (stack.func_190926_b() && !player.func_225608_bj_() && handIn == Hand.MAIN_HAND && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this && RopeBlock.removeRope(pos.func_177977_b(), world, this)) {
            world.func_184133_a(player, pos, SoundEvents.field_187748_db, SoundCategory.BLOCKS, 1.0f, 0.6f);
            if (player == null || !player.field_71075_bZ.field_75098_d) {
                CommonUtil.swapItem(player, handIn, stack, new ItemStack((IItemProvider)this.func_199767_j()));
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public static boolean removeRope(BlockPos pos, World world, Block ropeBlock) {
        BlockState state = world.func_180495_p(pos);
        if (ropeBlock == state.func_177230_c()) {
            return RopeBlock.removeRope(pos.func_177977_b(), world, ropeBlock);
        }
        BlockPos up = pos.func_177984_a();
        if (world.func_180495_p(up).func_177230_c() != ropeBlock) {
            return false;
        }
        FluidState fromFluid = world.func_204610_c(up);
        boolean water = fromFluid.func_206886_c() == Fluids.field_204546_a && fromFluid.func_206889_d();
        world.func_175656_a(up, water ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P());
        RopeBlock.tryMove(pos, up, world);
        return true;
    }

    public static boolean addRope(BlockPos pos, World world, @Nullable PlayerEntity player, Hand hand, Block ropeBlock) {
        BlockState state = world.func_180495_p(pos);
        if (ropeBlock == state.func_177230_c()) {
            return RopeBlock.addRope(pos.func_177977_b(), world, player, hand, ropeBlock);
        }
        return RopeBlock.tryPlaceAndMove(player, hand, world, pos, ropeBlock);
    }

    public static boolean tryPlaceAndMove(@Nullable PlayerEntity player, Hand hand, World world, BlockPos pos, Block ropeBlock) {
        BlockState state;
        ItemStack stack = new ItemStack((IItemProvider)ropeBlock);
        PlayerlessContext context = new PlayerlessContext(world, player, hand, stack, new BlockRayTraceResult(Vector3d.func_237489_a_((Vector3i)pos), Direction.UP, pos, false));
        if (!context.func_196011_b()) {
            BlockPos downPos = pos.func_177977_b();
            if (!world.func_180495_p(downPos).func_185904_a().func_76222_j() || !RopeBlock.tryMove(pos, downPos, world)) {
                return false;
            }
            context = new PlayerlessContext(world, player, hand, stack, new BlockRayTraceResult(Vector3d.func_237489_a_((Vector3i)pos), Direction.UP, pos, false));
        }
        if ((state = ropeBlock.func_196258_a((BlockItemUseContext)context)) == null || !CommonUtil.canPlace(context, state)) {
            return false;
        }
        if (state == world.func_180495_p(context.func_195995_a())) {
            return false;
        }
        if (world.func_180501_a(context.func_195995_a(), state, 11)) {
            BlockState placedState;
            Block block2;
            if (player != null && (block2 = (placedState = world.func_180495_p(context.func_195995_a())).func_177230_c()) == state.func_177230_c()) {
                block2.func_180633_a(world, context.func_195995_a(), placedState, (LivingEntity)player, stack);
                if (player instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, context.func_195995_a(), stack);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isObsidian(BlockState state) {
        return state.func_203425_a(Blocks.field_150343_Z) || state.func_203425_a(Blocks.field_235399_ni_) || state.func_203425_a(Blocks.field_235400_nj_);
    }

    private static boolean tryMove(BlockPos fromPos, BlockPos toPos, World world) {
        if (toPos.func_177956_o() < 0 || toPos.func_177956_o() > 255) {
            return false;
        }
        BlockState state = world.func_180495_p(fromPos);
        Block block2 = state.func_177230_c();
        PushReaction push = state.func_185905_o();
        if ((push == PushReaction.NORMAL || toPos.func_177956_o() < fromPos.func_177956_o() && push == PushReaction.PUSH_ONLY || ModTags.isTagged(ModTags.ROPE_HANG_TAG, block2)) && state.func_185887_b((IBlockReader)world, fromPos) != -1.0f && state.func_196955_c((IWorldReader)world, toPos) && !block2.isAir(state, (IBlockReader)world, fromPos) && !RopeBlock.isObsidian(state)) {
            FluidState fromFluid;
            TileEntity tile = world.func_175625_s(fromPos);
            if (tile != null) {
                if (CompatHandler.quark && !QuarkPistonPlugin.canMoveTile(state)) {
                    return false;
                }
                tile.func_145843_s();
            }
            boolean toFluid = world.func_204610_c(toPos).func_206886_c() == Fluids.field_204546_a;
            boolean canHoldWater = false;
            if (state.func_235901_b_((Property)WATERLOGGED) && !(canHoldWater = ModTags.isTagged(ModTags.WATER_HOLDER, state.func_177230_c()))) {
                state = (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(toFluid));
            }
            if (state.func_177230_c() instanceof CauldronBlock && toFluid) {
                state = (BlockState)state.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(3));
            }
            boolean leaveWater = (fromFluid = world.func_204610_c(fromPos)).func_206886_c() == Fluids.field_204546_a && fromFluid.func_206889_d() && !canHoldWater;
            world.func_175656_a(fromPos, leaveWater ? Blocks.field_150355_j.func_176223_P() : Blocks.field_150350_a.func_176223_P());
            BlockState newState = Block.func_199770_b((BlockState)state, (IWorld)world, (BlockPos)toPos);
            world.func_175656_a(toPos, newState);
            if (tile != null) {
                tile.func_174878_a(toPos);
                TileEntity target = TileEntity.func_235657_b_((BlockState)newState, (CompoundNBT)tile.func_189515_b(new CompoundNBT()));
                if (target != null) {
                    world.func_175690_a(toPos, target);
                    target.func_145836_u();
                }
            }
            world.func_190524_a(toPos, state.func_177230_c(), toPos);
            return true;
        }
        return false;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        super.func_196262_a(state, worldIn, pos, entityIn);
        if (entityIn instanceof ArrowEntity && !worldIn.field_72995_K) {
            worldIn.func_225521_a_(pos, true, entityIn);
            worldIn.func_184133_a(null, pos, SoundEvents.field_187746_da, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

