/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.tiles.TurnTableBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.Registry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TurnTableBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty INVERTED = BlockStateProperties.field_208188_o;
    public static final BooleanProperty ROTATING = BlockProperties.ROTATING;

    public TurnTableBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.UP)).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)ROTATING, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWER, INVERTED, ROTATING});
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196010_d().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (this.updatePower(state, world, pos) && (Integer)world.func_180495_p(pos).func_177229_b((Property)POWER) != 0) {
            this.tryRotate(world, pos);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        Direction mydir;
        Direction face = hit.func_216354_b();
        if (face != (mydir = (Direction)state.func_177229_b((Property)FACING)) && face != mydir.func_176734_d()) {
            if (!player.field_71075_bZ.field_75099_e) {
                return ActionResultType.PASS;
            }
            float f = (Boolean)(state = (BlockState)state.func_235896_a_((Property)INVERTED)).func_177229_b((Property)INVERTED) != false ? 0.55f : 0.5f;
            worldIn.func_184133_a(player, pos, SoundEvents.field_187556_aj, SoundCategory.BLOCKS, 0.3f, f);
            worldIn.func_180501_a(pos, state, 6);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    public boolean updatePower(BlockState state, World world, BlockPos pos) {
        int currentpower;
        int blockpower = world.func_175687_A(pos);
        if (blockpower != (currentpower = ((Integer)state.func_177229_b((Property)POWER)).intValue())) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TurnTableBlockTile) {
                TurnTableBlockTile turnTableBlockTile = (TurnTableBlockTile)te;
            }
            if (blockpower != 0) {
                state = (BlockState)state.func_206870_a((Property)ROTATING, (Comparable)Boolean.valueOf(true));
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(blockpower)), 6);
            return true;
        }
        return false;
    }

    private void tryRotate(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TurnTableBlockTile) {
            ((TurnTableBlockTile)te).tryRotate();
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.func_220069_a(state, world, pos, neighborBlock, fromPos, moving);
        boolean powerchanged = this.updatePower(state, world, pos);
        if ((Integer)world.func_180495_p(pos).func_177229_b((Property)POWER) != 0 && (powerchanged || fromPos.equals((Object)pos.func_177972_a((Direction)state.func_177229_b((Property)FACING))))) {
            this.tryRotate(world, pos);
        }
    }

    private static Vector3d rotateY(Vector3d vec, double deg) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vector3d.field_186680_a) {
            return vec;
        }
        double x = vec.field_72450_a;
        double y = vec.field_72448_b;
        double z = vec.field_72449_c;
        float angle = (float)(deg / 180.0 * Math.PI);
        double s = Math.sin(angle);
        double c = Math.cos(angle);
        return new Vector3d(x * c + z * s, y, z * c - x * s);
    }

    public static int getPeriod(BlockState state) {
        return 60 - (Integer)state.func_177229_b((Property)POWER) * 4 + 5;
    }

    public void func_176199_a(World world, BlockPos pos, Entity e) {
        super.func_176199_a(world, pos, e);
        if (!ServerConfigs.cached.TURN_TABLE_ROTATE_ENTITIES) {
            return;
        }
        if (!e.func_233570_aj_()) {
            return;
        }
        BlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((Property)POWER) != 0 && state.func_177229_b((Property)FACING) == Direction.UP) {
            float period = TurnTableBlock.getPeriod(state) + 1;
            float ANGLE_INCREMENT = 90.0f / period;
            float increment = (Boolean)state.func_177229_b((Property)INVERTED) != false ? ANGLE_INCREMENT : -1.0f * ANGLE_INCREMENT;
            Vector3d origin = new Vector3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            Vector3d oldpos = e.func_213303_ch();
            Vector3d oldoffset = oldpos.func_178788_d(origin);
            Vector3d newoffset = TurnTableBlock.rotateY(oldoffset, increment);
            Vector3d posdiff = origin.func_178787_e(newoffset).func_178788_d(oldpos);
            e.func_213315_a(MoverType.SHULKER_BOX, posdiff);
            e.field_70133_I = true;
            if (e instanceof LivingEntity) {
                TileEntity te;
                e.func_230245_c_(false);
                float diff = e.func_70079_am() - increment;
                e.func_181013_g(diff);
                e.func_70034_d(diff);
                ((LivingEntity)e).field_70758_at = ((LivingEntity)e).field_70759_as;
                ((LivingEntity)e).func_213332_m(20);
                if (e instanceof CatEntity && ((TameableEntity)e).func_233685_eM_() && !world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TurnTableBlockTile) {
                    TurnTableBlockTile table = (TurnTableBlockTile)te;
                    if (table.cat == 0) {
                        ((TurnTableBlockTile)te).cat = 400;
                        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, (SoundEvent)Registry.TOM_SOUND.get(), SoundCategory.BLOCKS, 0.85f, 1.0f);
                    }
                }
            }
            e.field_70177_z -= increment;
            e.field_70126_B = e.field_70177_z;
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TurnTableBlockTile();
    }
}

